<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Models\Role;
use App\Models\RoleQuestions;
use Illuminate\Http\Request;
use DB;

class RolesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        define('PAGE_LIMIT', 10);
    }

    public function index(Request $request)
    {
        if ($request->isMethod('post')) {
            $requestData = $request->all();

            Role::destroy($requestData['id']);

            Role::where('id', $requestData['id'])->delete();

            return redirect()->route('admin.roles')->with('flash_message', 'Role deleted successfully!');
        } else {
            $records = Role::orderBy('id', 'asc')
                ->paginate(PAGE_LIMIT);
        }
        $data = array();
        $data['active_menu'] = 'roles';
        $data['sub_active_menu'] = 'roles-list';
        $data['title'] = 'Job Roles';
        $data['records'] = $records;
        return view('backend.roles.list', $data);
    }

    public function addNewRoles(Request $request, $id = null)
    {

        if ($request->isMethod('post')) {

            $requestData = $request->all();
			

            $this->validate(request(), [
                'name' => 'required'
            ], [

                'name.required' => 'Enter name'
            ]);


//            dd($requestData);

            $requestData['joining_date']= isset($requestData['joining_date'])? date('Y-m-d', strtotime($requestData['joining_date'])) : null;

          // dd($requestData);
			$requestArr= array('name'=>$request->name,
								   'country'=>$request->country,
								   'city'=>$request->city,
								   'currency_id'=>$request->currency_id,
								   'salary'=>$request->salary,
								   'job_type'=>$request->job_type,
								   'joining_date'=>date('Y-m-d',strtotime($request->joining_date)),
								   'industry'=>$request->industry,
								   'role_details'=>$request->role_details,
								   'role_expectations'=>$request->role_expectations,
								   'after_apply'=>$request->after_apply,
								   'salary_incentives'=>$request->salary_incentives,
								   'company_name'=>$request->company_name,
								   'experience_from'=>$request->experience_from,
								   'experience_to'=>$request->experience_to
								);
            if ($requestData['id'] == '') {
				
                $roles = Role::create($requestArr);
				
				$questions = $request->questions;
				if(is_array($questions) && count($questions)>0) {
					foreach($questions as $key=>$value) {
						DB::insert("insert into roles_interview_questions set role_id='".$roles->id."', questions='$value'");
					}
				}
                $mes = 'Role added successfully!';
            } else {

                $record = Role::findOrFail($requestData['id']);
                $record->update($requestArr);
				$questions = $request->questions;
				if(is_array($questions) && count($questions)>0) {
					DB::delete("delete from roles_interview_questions where role_id='".$requestData['id']."'");
					foreach($questions as $key=>$value) {
						DB::insert("insert into roles_interview_questions set role_id='".$requestData['id']."', questions='$value'");
					}
				}
                $mes = 'Role updated successfully!';
            }
            return redirect()->route('admin.roles')->with('flash_message', $mes);

        } else {
            $data = array();
            $data['id'] = '';
            $data['record'] = '';
            if ($id) {
                $data['id'] = $id;
                $data['record'] = Role::findOrFail($id);
                $data['questions'] = RoleQuestions::where('role_id', $id)->get();
				$data['roles_questions']  = DB::select("select * from roles_interview_questions where role_id='$id'");
				$data['roles_title']  = DB::select("select * from roles_title where role_id='$id'");
			}
            $data['active_menu'] = 'roles';
            $data['sub_active_menu'] = 'manage-roles';
            $data['title'] = 'Manage  Job R	oles';
            $data['countryLists'] = Country::get();
			$ip = $_SERVER['REMOTE_ADDR'];
			$ipDetails = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
			
			if(isset($ipDetails->country)) {
				$data['country'] = $ipDetails->country;
				$data['city'] = $ipDetails->city;
			}
			
			return view('backend.roles.add', $data);
        }
    }

    public function addNewQuestions(Request $request, $id = null)
    {

        if ($request->isMethod('post')) {

            $requestData = $request->all();


            if ($requestData['action'] == 'add') {

                if ($requestData['question_type'] == 'radio') {
                    $options = 'required';
                } else {
                    $options = '';
                }

                $this->validate(request(), [
                    'question' => 'required',
                    'question_type' => 'required',
                    'option1' => $options,
                    'option2' => $options,
                ], [

                    'question.required' => 'Enter question',
                    'question_type.required' => 'Select type',
                    'option1.required' => 'Enter option',
                    'option2.required' => 'Enter option',
                ]);


                RoleQuestions::create($requestData);

                $mes = 'Role questionadded successfully!';
            } elseif ($requestData['action'] == 'remove') {
                RoleQuestions::destroy($requestData['id']);
                $mes = 'Role Question deleted successfully!';
            } else {

                if ($requestData['question_type'] == 'radio') {
                    $options = 'required';
                } else {
                    $options = '';
                }

                $this->validate(request(), [
                    'question' => 'required',
                    'question_type' => 'required',
                    'option1' => $options,
                    'option2' => $options,
                ], [

                    'question.required' => 'Enter question',
                    'question_type.required' => 'Select type',
                    'option1.required' => 'Enter option',
                    'option2.required' => 'Enter option',
                ]);

                $record = RoleQuestions::findOrFail($requestData['id']);
                $record->update($requestData);
                $mes = 'Role Question updated successfully!';
            }
            return redirect()->route('admin.addNewRoles', ['id' => $requestData['role_id']])->with('flash_message', $mes);

        }
    }
	public function addRoleTitle(Request $req) {
		$title = $req->title;
		$role_id = $req->role_id;
		$roleInfo = DB::select("select * from roles_title where role_id='$role_id'");
		if(isset($req->flag) && $req->flag==1) {
			if(is_array($roleInfo) && count($roleInfo)>0) {
			DB::update("update roles_title set after_apply='$title' where role_id='$role_id'");
			} else {
				DB::insert("insert into roles_title set role_id='$role_id', after_apply='$title'");
			}
		} else if(isset($req->flag) && $req->flag==2) {
			if(is_array($roleInfo) && count($roleInfo)>0) {
			DB::update("update roles_title set salary_incentive='$title' where role_id='$role_id'");
			} else {
				DB::insert("insert into roles_title set role_id='$role_id', salary_incentive='$title'");
			}
		} else {
			if(is_array($roleInfo) && count($roleInfo)>0) {
				DB::update("update roles_title set role_expectation='$title' where role_id='$role_id'");
			} else {
				DB::insert("insert into roles_title set role_id='$role_id', role_expectation='$title'");
			}
		}
		echo '1';
	}
	public function listNewRoles(Request $req) {
		$records = Role::where('id', $req->id)->get()->toArray();
		$data['active_menu'] = 'roles';
		$data['sub_active_menu'] = 'manage-roles';
		$data['title'] = 'Display Job Role';
		$data['record']= $records;
		$data['id'] = $req->id;
		$data['questions'] = RoleQuestions::where('role_id', $req->id)->get();
		$data['roles_questions']  = DB::select("select * from roles_interview_questions where role_id='".$req->id."'");
		//echo '<pre>';
		//print_r($records);
		return view('backend.roles.listrole', $data);
	}
}
