<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Candidate extends Model
{
    use HasFactory;

    protected $fillable = [
        'full_name',
        'email',
        'phone',
        'mobile',
        'country_code',
        'date_of_birth',
        'gender',
        'job_profile',
        'address',
        'city',
        'state',
        'country',
        'zip',
        'current_salary',
        'expected_salary',
        'total_experience_in_year',
        'summary',
        'path',
        'vendor_id',
        'vendor_user_id',
        'asset_id',
        'note',
        'title',
        'first_name',
        'middle_name',
        'last_name',
        'father_name',
        'mother_name',
        'marital_status',
        'nationality',
        'language_known',
        'unique_id',
        'license_no',
        'passport_no',
        'pan_no',
        'visa_status',
        'alternate_email',
        'cover_letter',
        'certification',
        'publication',
        'current_location',
        'preferred_location',
        'availability',
        'objectives',
        'candidate_references',
        'parsing_date',
        'resume_language',
        'resume_file_name',
        'formatted_address',
        'permanent_address',
        'permanent_city',
        'permanent_state',
        'permanent_country',
        'permanent_zip_code',
        'formatted_permanent_address',
        'industry_category',
        'industry_sub_category',
        'qualification',
        'executive_summary',
        'management_summary',
        'skills',
        'soft_skills',
        'operational_skills',
        'hobbies',
        'candidate_achievements',
        'is_privatearea',
        'is_alive',
        'buyout',
        'html_code',
        'created_at',
        'is_active_private',
        'preferred_country',
        'present_country',
        'nationality',
        'work_autherization',
        'currency',
        'buyout',
        'currentservingnotice',

    ];


    public function getCandidateDetails()
    {
        return $this->belongsTo(CandidateDetail::class, 'id', 'candidate_id');
    }


    public function getExperience()
    {
        return $this->hasMany(CandidateExperience::class, 'candidate_id', 'id');
    }


    public function getSkill()
    {
        return $this->hasOne(CandidateSkill::class, 'candidate_id');
    }


    public function getNote()
    {
        return $this->hasOne(CandidateNote::class, 'candidate_id');
    }

    public function educations()
    {
        return $this->hasMany(CandidateEducation::class, 'candidate_id');
    }

    public function candidate_soft_skill()
    {
        return $this->hasMany(CandidateSoftSkill::class, 'candidate_id');
    }

    public function vendor()
    {
        return $this->belongsTo(User::class, 'vendor_id');
    }

    public function vendoruser()
    {
        return $this->belongsTo(User::class, 'vendor_user_id');
    }

    public function candidate_operational_skill()
    {
        return $this->hasMany(CandidateOperationalSkill::class, 'candidate_id');
    }
//    public function asset() {
//        return $this->belongsTo('App\UserAsset','asset_id');
//    }
}
