<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class CandidateVideoInterviews extends Model
{
    use HasFactory;

    protected $fillable = [
        'candidate_id',
        'video_category_id',
        'video_id',
        'video_file',

    ];

    public function geCandidate()
    {
        return $this->belongsTo(User::Class, 'candidate_id');
    }

    public function getCategory()
    {
        return $this->belongsTo(VideoInterviewCategories::Class, 'video_category_id', 'id');
    }

    public function getRefVideo()
    {
        return $this->belongsTo(VideoInterviewCategoriesVideos::Class, 'video_id');
    }



    public static function uploadDir($url = null)
    {
        $folder = '/uploads/video_interview';
        if ($url == 'url') {
            return url($folder . '/');
        } else {
            return public_path($folder);
        }
    }

    public static function uploadImage($request, $input, $oldImage = null)
    {
        if ($request->hasFile($input)) {

            $file = $request->file($input);

//            dd($file);

            $imagefilesTypes = array(
                'jpeg', 'png', 'jpg', 'gif'
            );


            $uploadPath = self::uploadDir();
            $extension = $file->getClientOriginalExtension();
            $fileName = 'gallery_' . uniqid() . '_' . time() . '.' . $extension;


            $file->move($uploadPath, $fileName);


            if ($oldImage != null) {
                if ($oldImage != null && $fileName != '') {
                    File::delete($uploadPath . '/' . $oldImage);
                }
            }
            return $fileName;
        }
    }


    public static function uploadVideo($request, $input, $oldImage = null)
    {
        if ($request->hasFile($input)) {


            $responce = array();

            $file = $request->file($input);

//            dd($file);


            $uploadPath = self::uploadDir();
            $extension = $file->getClientOriginalExtension();
            $fileName = 'interview_' . uniqid() . '_' . time() . '.' . $extension;

            $allowed = array(
                'webm',
                'wav',
                'mp4',
                'mkv',
                'mp3',
                'ogg'
            );

            if (!$extension || empty($extension) || !in_array($extension, $allowed)) {

                $responce['error'] = 1;
                $responce['msg'] = 'Invalid file extension: ' . $extension;;


                return $responce;
            }


            $file->move($uploadPath, $fileName);


            if ($oldImage != null) {
                if ($oldImage != null && $fileName != '') {
                    File::delete($uploadPath . '/' . $oldImage);
                }
            }

            $responce['error'] = 200;
            $responce['msg'] = 'Success ';
            $responce['filename'] = $fileName;

            return $responce;
        }
    }


}
