<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\CandidateVideoInterviews;
use App\Models\VideoInterviewCategories;
use App\Models\VideoInterviewCategoriesVideos;
use Illuminate\Http\Request;
use DB;

class VideoInterviewCategoriesVideosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        define('PAGE_LIMIT', 30);
    }

    public function index(Request $request)
    {
        if ($request->isMethod('post')) {
            $requestData = $request->all();

            VideoInterviewCategoriesVideos::destroy($requestData['id']);

            return redirect()->route('admin.videos.videos')->with('flash_message', 'Category deleted successfully!');
        } else {
            $records = VideoInterviewCategoriesVideos::orderBy('id', 'desc')
                ->paginate(PAGE_LIMIT);
        }
        $data = array();
        $data['active_menu'] = 'videos';
        $data['sub_active_menu'] = 'videos-list';
        $data['title'] = 'videos';
        $data['records'] = $records;
        return view('backend.videos.list', $data);
    }

    public function addNewCategoriesVideos(Request $request, $id = null)
    {

        if ($request->isMethod('post')) {
			
            $requestData = $request->all();
			
			if(!empty($request->file("file_name"))) {
				
				if (!empty($_FILES['file_name'])) {
					$file_idx = 'file_name';
				} else {
					$file_idx = '';
				}
				
				$vidoeFile = VideoInterviewCategoriesVideos::uploadVideo($request, $file_idx);
				DB::insert("insert into video_manual set cat_id='$id', video_filename='".$vidoeFile['filename']."'");
				$mes ="Manaul video added successfully.";
				return redirect()->route('admin.videos.addNewCategoriesVideos',$id)->with('flash_message', $mes);
			}

            $this->validate(request(), [
                'video_name' => 'required',
                'category_id' => 'required',
//                'video_url' => 'required',
                'video_duration' => 'required|numeric',
                'status' => 'required',
            ], [

                'video_name.required' => 'Enter name',
                'category_id.required' => 'select category',
//                'video_url.required' => 'Enter url',
                'video_duration.required' => 'Enter duration',
                'status.required' => 'select status'
            ]);


            if ($requestData['id'] == '') {


                VideoInterviewCategoriesVideos::create($requestData);

                $mes = 'Video added successfully!';
            } else {

                $record = VideoInterviewCategoriesVideos::findOrFail($requestData['id']);
                $record->update($requestData);
                $mes = 'Video updated successfully!';
            }
            return redirect()->route('admin.videos.videos')->with('flash_message', $mes);

        } else {
            $data = array();
            $data['id'] = '';
            $data['record'] = '';
            if ($id) {
                $data['id'] = $id;
                $record = VideoInterviewCategoriesVideos::findOrFail($id);
				
                if($record->video_url != ''){
                    $record->video_file_url = VideoInterviewCategoriesVideos::uploadDir('url').'/'.$record->video_url;
                }else{
                    $record->video_file_url = null;
                }
				$videoInfo = DB::select("select * from video_manual where cat_id='$id' order by id desc limit 1");
				if($videoInfo[0]->created_at > $record->created_at) {
					
					$record->video_file_url = $videoInfo[0]->video_filename;
				}
                $data['record'] =$record;

            }
            $data['active_menu'] = 'videos';
            $data['sub_active_menu'] = 'manage-videos';
            $data['title'] = 'Manage videos';
            return view('backend.videos.add', $data);
        }
    }
	public function manauallyUploadVideos(Request $request) {
		
		if (!empty($_FILES['file_name'])) {
            $file_idx = 'file_name';
        } else {
            $file_idx = 'file_name';
        }

        $vidoeFile = VideoInterviewCategoriesVideos::uploadVideo($request, $file_idx);
		print_r($vidoeFile);exit;
        if (!empty($vidoeFile) && $vidoeFile['error'] == 200) {


            $inserVideoArray = array();

            //$catVideoInfo->video_url = $vidoeFile['filename'];

           // $catVideoInfo->save();
		}

            $responce['error'] = 200;
            $responce['msg'] = 'success';

            return $responce;
	}
}
