<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class VideoInterviewCategoriesVideos extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'video_name',
        'video_duration',
        'video_url',
        'status',

    ];

    public function catinfo()
    {
        return $this->belongsTo(VideoInterviewCategories::class, 'category_id');
    }


    public static function uploadDir($url = null)
    {
        $folder = '/uploads/category_interview';
        if ($url == 'url') {
            return url($folder . '/');
        } else {
            return public_path($folder);
        }
    }


    public static function uploadVideo($request, $input, $oldImage = null)
    {
        if ($request->hasFile($input)) {


            $responce = array();

            $file = $request->file($input);

//            dd($file);


            $uploadPath = self::uploadDir();
            $extension = $file->getClientOriginalExtension();
            $fileName = 'interview_' . uniqid() . '_' . time() . '.' . $extension;

            $allowed = array(
                'webm',
                'wav',
                'mp4',
                'mkv',
                'mp3',
                'ogg'
            );

            if (!$extension || empty($extension) || !in_array($extension, $allowed)) {

                $responce['error'] = 1;
                $responce['msg'] = 'Invalid file extension: ' . $extension;;


                return $responce;
            }


            $file->move($uploadPath, $fileName);


            if ($oldImage != null) {
                if ($oldImage != null && $fileName != '') {
                    File::delete($uploadPath . '/' . $oldImage);
                }
            }

            $responce['error'] = 200;
            $responce['msg'] = 'Success ';
            $responce['filename'] = $fileName;

            return $responce;
        }
    }



}
