@extends('backend.layout')
@section('title', $title)

@section('headerStyles')

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            display: none;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #3c8dbc;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
{{--    <link rel="stylesheet prefetch" href="https://preview.codepad.co/css/normalize.min.css"/>--}}

@endsection

@section('content')

    {!! getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              ''=>'Categories'
              ),'Categories'
           ) !!}

    <div class="container mt-3">


        {{--        <div class="">--}}
        <div class="animated fadeIn">




            <div class="row">

                <div class="col-lg-12">
                    @if (Session::has('flash_message'))
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong>{{ Session::get('flash_message' ) }}</strong>
                        </div>
                    @endif
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Videos</strong>
                            <a href="{{route('admin.videos.addNewCategories')}}" class="btn btn-primary btn-xs"
                               style="float:right;">Add
                                Category
                            </a>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-12">

                                    @if(count($records)>0)

                                        <div class="list_sort_box row">

                                            @foreach($records as $item)

                                                <div class="list-item">
                                                    <div class="item-content">
                                                        <span data-cat_id="{{ $item->id }}" class="order">{{ $item->sort_no }}</span>
                                                        {{ $item->name }}


                                                        <div class="dropdown float-right">
                                                            <a class="btn btn-outline-primary dropdown-toggle" href="#"
                                                               role="button"
                                                               data-toggle="dropdown">
                                                                <i class="fa fa-ellipsis-h"></i>
                                                            </a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <a class="dropdown-item"
                                                                   href="{{ route('admin.videos.addNewCategories',['id'=>$item->id]) }}"><i
                                                                        class="fa fa-pencil"></i> Edit</a>
                                                                <form method="POST" id="videos"
                                                                      action="{{ route('admin.videos.categories') }}"
                                                                      accept-charset="UTF-8" class="form-horizontal"
                                                                      style="display:inline">
                                                                    {{ csrf_field() }}
                                                                    <input type="hidden" name="id"
                                                                           value="{{ $item->id }}"/>
                                                                    <button type="submit" class="dropdown-item"
                                                                            title="Delete Record"
                                                                            onclick="return confirm(&quot;Confirm delete?&quot;)">
                                                                        <i
                                                                            class="fa fa-trash"></i> Delete
                                                                    </button>

                                                                </form>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                            @endforeach

                                        </div>

                                    @else
                                        No records found
                                    @endif
<div class="clearfix"></div>

                                </div>
                            </div>


                           {{-- <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($records)>0)
                                    @foreach($records as $item)
                                        <tr>
                                            <th scope="row">{{ $loop->iteration }}</th>
                                            <td>{{ $item->name }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    <a class="btn btn-outline-primary dropdown-toggle" href="#"
                                                       role="button"
                                                       data-toggle="dropdown">
                                                        <i class="fa fa-ellipsis-h"></i>
                                                    </a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <a class="dropdown-item"
                                                           href="{{ route('admin.videos.addNewCategories',['id'=>$item->id]) }}"><i
                                                                class="fa fa-pencil"></i> Edit</a>
                                                        <form method="POST" id="videos"
                                                              action="{{ route('admin.videos.categories') }}"
                                                              accept-charset="UTF-8" class="form-horizontal"
                                                              style="display:inline">
                                                            {{ csrf_field() }}
                                                            <input type="hidden" name="id"
                                                                   value="{{ $item->id }}"/>
                                                            <button type="submit" class="dropdown-item"
                                                                    title="Delete Record"
                                                                    onclick="return confirm(&quot;Confirm delete?&quot;)">
                                                                <i
                                                                    class="fa fa-trash"></i> Delete
                                                            </button>

                                                        </form>

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="3">No records found</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>--}}
                        </div>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md-10">
                    <div class="dataTables_info p-t-10" id="editable-datatable_info" role="status"
                         aria-live="polite">Showing {{ $records->firstItem() }}
                        to {{ $records->lastItem() }} of {{ $records->total() }} entries
                    </div>
                </div>
                <div class="col-md-1 text-right">
                    <div class="dataTables_paginate paging_simple_numbers" id="editable-datatable_paginate">
                        {!! $records->appends(['filters' => Request::get('filters'),'search' => Request::get('search')])->render() !!}
                    </div>
                </div>
            </div>
        </div><!-- .animated -->
    </div><!-- .content -->

@endsection
@section('footerScripts')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/1.18.4/TweenMax.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/1.18.4/utils/Draggable.min.js"></script>


    <script>
        var rowSize = 60; // => container height / number of items
        var container = document.querySelector(".list_sort_box");
        var listItems = Array.from(document.querySelectorAll(".list-item")); // Array of elements
        var sortables = listItems.map(Sortable); // Array of sortables
        var total = sortables.length;

        TweenLite.to(container, 0.5, {autoAlpha: 1});

        function changeIndex(item, to) {

            // Change position in array
            arrayMove(sortables, item.index, to);

            // Change element's position in DOM. Not always necessary. Just showing how.
            if (to === total - 1) {
                container.appendChild(item.element);
            } else {
                var i = item.index > to ? to : to + 1;
                container.insertBefore(item.element, container.children[i]);
            }

            // Set index for each sortable
            sortables.forEach((sortable, index) => sortable.setIndex(index));
        }

        function Sortable(element, index) {

            var content = element.querySelector(".item-content");
            var order = element.querySelector(".order");

            var animation = TweenLite.to(content, 0.3, {
                boxShadow: "rgba(0,0,0,0.2) 0px 16px 32px 0px",
                force3D: true,
                scale: 1.1,
                paused: true
            });

            var dragger = new Draggable(element, {
                onDragStart: downAction,
                onRelease: upAction,
                onDrag: dragAction,
                cursor: "inherit",
                type: "y"
            });

            // Public properties and methods
            var sortable = {
                dragger: dragger,
                element: element,
                index: index,
                setIndex: setIndex
            };

            TweenLite.set(element, {y: index * rowSize});

            function setIndex(index) {

                sortable.index = index;
                order.textContent = index + 1;



                // Don't layout if you're dragging
                if (!dragger.isDragging) layout();
            }

            function downAction() {
                animation.play();
                this.update();


            }

            function dragAction() {

                // Calculate the current index based on element's position
                var index = clamp(Math.round(this.y / rowSize), 0, total - 1);

                if (index !== sortable.index) {
                    changeIndex(sortable, index);
                }


            }

            function upAction() {
                animation.reverse();
                layout();

                var selected_value = [];
                $(".order").each(function() {
                    // selected_value.push( {[$(this).data('cat_id')]: $(this).text()} );

                    var thisCatId = $(this).data('cat_id');

                    selected_value.push( thisCatId + ','+ $(this).text());

                });
                var myJSON = JSON.stringify(selected_value);
                // var myJSON = JSON.parse(selected_value);
                console.log(myJSON)
                // console.log('cat id '+selected_value)


                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: '{{ route('saveCategoryVideoSort') }}', // replace with your own server URL
                    data: {'postdata': selected_value},

                    type: 'POST',
                    success: function (response) {
                       console.log(response)

                    }
                });



            }

            function layout() {
                TweenLite.to(element, 0.3, {y: sortable.index * rowSize});
            }



            return sortable;
        }

        // Changes an elements's position in array
        function arrayMove(array, from, to) {
            array.splice(to, 0, array.splice(from, 1)[0]);
        }

        // Clamps a value to a min/max
        function clamp(value, a, b) {
            return value < a ? a : (value > b ? b : value);
        }


    </script>

@endsection
