@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
     *{margin:0px; padding:0px;}
	 body{font-family: 'Poppins', sans-serif;}
	 .p_tag {
    color: #ababab;
}
select.form-control:not([size]):not([multiple]) {
    height: calc(4.25rem + 2px);
}
.f_po1{
    border-radius: 0px;
    border: 2px dotted #ccc;
	}
.f_po {
    border-radius: 0px;
    height: 42px;
    border: 2px dotted #ccc;
}
.l_fom {
    width: 100%;
    float: left;
}

.l_txt {
    color: #808080;
    font-weight: 500;
	padding:0px;
}
.ma_details {
    padding: 0px;
}
.se_tag {
    background: #f7f7f7;
    clear: both;
    padding: 26px;
	overflow:auto;
}
.q-tag {
    font-size: 16px;
}
.a-tag {
    color: #9c9c9c;
}
.btn_pr {
    float: right;
    color: #8f24f9;
    background: none;
    border: 2px solid #8f24f9;
}
.btn_pr:hover{
	    color: #8f24f9;
    background: none;
	border: 2px solid #8f24f9;
	}
.tab_ht {
    border: 1px solid #ccc;
}
.btn_edit {
    padding: 4px 15px;
    border-radius: 0px;
    background: #8f24f9;
    font-size: 13px;
}
.err_or {
    color: red;
}
.ro_qs {
    font-size: 19px;
    color: #8f24f9;
}
.la_w {
    width: 100%;
}
.for_gr {
    border: 1px solid #ccc;
    width: 100%;
    height: 34px;
	border-radius:0px;
}
.b_pr {
    border-radius: 0px;
    background: #8f24f9;
}
.b_pr:hover{
    border-radius: 0px;
    background: #8f24f9;
}
.w_del{width:22px;}
.chan_w{
    width: 70%;
    float: left;
}
.curr_ny{width:20%; float:left;}
.w_ctr{width:80%;}
.mi_edit {
    position: absolute;
    top: 150px;
}

.f_po13 {
    width: 85%;
}
.bt_remove {
    padding: 3px;
    top: 20px;
    border: 1px solid #ffc3ce !important;
    border-radius: 15px;
    background: none !important;
    box-shadow: none;
    color: #ff5576 !important;
    width: 15%;
    right: 0px;
    position: absolute;
}
._rdel {
    width: 25px;
}
.bt_remove:hover {
    padding: 3px;
    top: 20px;
    border: 1px solid #ffc3ce !important;
    border-radius: 15px;
    background: none !important;
    box-shadow: none;
    color: #ff5576 !important;
    width: 15%;
    right: 0px;
    position: absolute;
}
.b_tq {
    background: #8f24f9;
    border: none;
    border-radius: 0px;
    float: right;
}
.b_tq:hover{
    background: #8f24f9;
    border: none;
    border-radius: 0px;
    float: right;
}
.file {
    width: 14%;
    margin: auto;
    text-align: center;
    margin-left: 16px;
}
.file.btn.btn-lg.btn-primary {
    cursor: pointer !important;
    color: #ffffff;
    line-height: 22px;
    border-radius: 0px;
    height: 45px;
    background: #b674f8;
    border: 2px dotted #b674f8;
}
.p_qw {
  position: absolute;
  font-size: 50px;
  opacity: 0;
  right: 0;
  top: 0;
}
.bt_rq {
    border-radius: 0px;
    background: #9b56e0;
    border-color: #9b56e0;
    padding: 7px 10px;
}
.bt_st {
    background: #dc3545;
    border-color: #dc3545;
    border-radius: 0px;
    padding: 7px 12px;
}
.ta_bq {
    padding: 0px;
}
.te_ctr {
    color: #fff;
    background: #9b56e0;
}
.l_w1 {
    width: 13%;
    float: left;
}
.l_w {
    width: 20%;
    float: left;
}
.navbar-default {
    width: 100% !important;
     background-color: #272c33 !important;
     border-color: #272c33 !important;
}
aside.left-panel {
    padding: 0 0px;

}
.navbar .navbar-nav li > a .menu-icon {
    width: 16px;
}

/*------------ choise file upload -------------*/

.btn-tertiary {
color: #555;
    padding: 0;
    line-height: 40px;
    width: 100%;
    margin: auto;
    border-radius: 0px;
    display: block;
    border: 2px dotted #9b56e0;
  &:hover, 
    &:focus {
      color: lighten(#555, 20%);
      border-color: lighten(#555, 20%);
    }
}

/* input file style */

.input-file {
	width: 0.1px;
	height: 0.1px;
	opacity: 0;
	overflow: hidden;
	position: absolute;
	z-index: -1;
  + .js-labelFile {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    padding: 0 10px;
    cursor: pointer;
    .icon:before {
      //font-awesome
      content: "\f093";
    }
    &.has-file {
      .icon:before {
        //font-awesome
        content: "\f00c";
        color: #5AAC7B;
      }
    }
  }
}


@media screen and (min-width:320px) and (max-width:767px) {
.ta_bq {
    overflow-x: scroll;
}
.l_w {
    width: 50%;
    float: left;
}
.l_w1 {
    width: 31%;
    float: left;
}
.file {
    width: 90%;
    margin-top: 10px;
}
	
}

  </style>

@endsection

@section('content')
    {!! getBreadcrumbs(
               array(
               'dashboard'=>'Home',

               ''=>'Emails-Notifications'
               ),'Emails-Notifications'
            ) !!}
  
   <div class="container">
	 @if (Session::has('flash_message'))
		<br/>
		<div class="alert alert-success alert-dismissable">
			<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
			<strong>{{ Session::get('flash_message' ) }}</strong>
		</div>
	@endif
	@php $readonly="";
	$tooltip="";
	@endphp
	
	@if($title==1 && $desc==1 && $video==1)
<form method="POST" id="notifications" action="{{ route('admin.emails_notifications') }}" accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
<div class="se_tag">
   <div class="col-md-12 l_fom">
	
      {{ csrf_field() }}
     
        <div class="form-group">
          <label class="col-md-2 l_txt">Title<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
			<input class="form-control f_po" id="campaign_title" type="text"
                                               placeholder="Title" data-toggle="tooltip" name="campaign_title">
			@if ($errors->has('campaign_title'))
				<span
					class="text-danger help-block">{{ $errors->first('campaign_title') }}</span>
			@endif
          </div>
        </div>
        
        <!--<div class="form-group">
          <label class="col-md-2 l_txt">Candidates<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
			<input class="form-control f_po" id="senders" type="text"
                                               placeholder="Candidates Details separated by comma"
                                               name="senders"  data-toggle="tooltip">
			@if ($errors->has('senders'))
				<span class="text-danger help-block">{{ $errors->first('senders') }}</span>
			@endif
          </div>
        </div>-->
        
         <div class="form-group">
          <label class="col-md-2 l_txt">Template<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
			<select class="form-control f_po" id="template" name="template" data-toggle="tooltip">
				<option value="">Select Template</option>
				@foreach(templates() as $key=>$template)
					<option value="{{ $key }}">{{ $template }}</option>
				@endforeach

			</select>
			@if ($errors->has('senders'))
				<span class="text-danger help-block">{{ $errors->first('senders') }}</span>
			@endif
           
          </div>
        </div>
        
         <div class="form-group">
          <label class="col-md-2 l_txt">Html Template Preview<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
			<textarea class="form-control f_po preview" name="preview" data-toggle="tooltip"></textarea>
			@if ($errors->has('senders'))
				<span class="text-danger help-block">{{ $errors->first('senders') }}</span>
			@endif
            
          </div>
        </div>
        
        <div class="form-group">
         <label class="col-md-2 l_txt">Upload CSV<span class="err_or">*</span></label>
         
              <div class="col-md-8 ch_fil">
                 <input type="file" name="file" id="file" class="input-file">
                  <label for="file" class="btn btn-tertiary js-labelFile">
                    <i class="icon fa fa-check"></i>
                    <span class="js-fileName">Choose a file</span>
                  </label>
             </div>
           <button class="col-md-2 file btn btn-lg btn-primary" type="button" id="btnSubmit">
				Upload
			
			</button>
           
             
        </div>
        
           <div class="form-group">
         <label class="col-md-2 l_txt"></label>
           <div class="col-md-10 gr_p">
			 <button class="btn btn-primary bt_rq">Submit</button>
             <button class="btn btn-primary bt_st">Reset</button>
			</div>
        </div>
        

        
    
     
     </div>
   </div>
   
   
   <div class="col-md-12 ta_bq" style="margin-top:15px;">
   <form action="#">
      <p class="l_w">
        <input type="radio" id="test1" name="email_sms" checked value="1">
        <label for="test1">Send SMS and Email</label>
      </p>
      <p class="l_w1">
        <input type="radio" id="test2" name="email_sms" value="2">
        <label for="test2">Send Email</label>
      </p>
      <p class="l_w1">
        <input type="radio" id="test3" name="email_sms" value="3">
        <label for="test3">Send SMS</label>
      </p>
    </form>
      <table class="table table-hover tab_ht" cellpadding="5" cellspacing="3">
            <thead class="te_ctr">
              <tr>
                <th><input type="checkbox" name="checkA" id="checkA" onclick="return checkAll(this);" value="1"></th>
				<th>First Name</th>
                <th>Last Name</th>
                <th>Email</th>
                <th>Mobile Number</th>
              </tr>
            </thead>
            <tbody class="b_dy">
               
            </tbody>
          </table>
   </div>
    </form>
	@else
	<div class="container">
	  <div class="col-md-8 col-md-offset-3 mai_bq text-center">
		 
		 <p class="th_p">Please update company info, videos and job title</p>
	  </div>
   </div>
	@endif
       
   </div>
   
   @endsection
@section('footerScripts')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script src="//cdn.jsdelivr.net/bootstrap.tagsinput/0.4.2/bootstrap-tagsinput.min.js"></script>


    <script>
    function checkAll(ele) {
		
		 var checkboxes = document.getElementsByName('emailAndSms[]');
		 if (ele.checked) {
			 
			 for (var i = 0; i < checkboxes.length; i++) {
				 if (checkboxes[i].type == 'checkbox') {
					 checkboxes[i].checked = true;
				 }
			 }
		 } else {
			 for (var i = 0; i < checkboxes.length; i++) {
				 console.log(i)
				 if (checkboxes[i].type == 'checkbox') {
					 checkboxes[i].checked = false;
				 }
			 }
		 }
	 }

	$(document).on('click', '#btnSubmit', function(){
		
		var formData = new FormData();
		formData.append('file', document.getElementById("file").files[0]);

		$.ajax({
		   url:"{{ route('admin.ajaxfileupload') }}",
		   method:"POST",
		   data:formData,
		   processData: false,
		   contentType: false,
		   headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
		   success:function(data)
		   {
				var alldata =data.split('~');
				var allfirstnames = alldata[0].split(',');
				var alllastnames = alldata[1].split(',');
				var allemails = alldata[2].split(',');
				var allphones = alldata[3].split(',');
				var emailStr="";
				for(var i=0; i<allemails.length; i++) {
					emailStr += `<tr>
								<td><input type="checkbox" id="emailAndSms" name="emailAndSms[]" value="`+i+`"></td>
								<td><input type="text" class="form-control f_po" name="first_name[]" value="`+allfirstnames[i]+`" readonly></td>
								<td><input type="text" class="form-control f_po" name="last_name[]" value="`+alllastnames[i]+`" readonly></td>
								<td><input type="text" class="form-control f_po" name="emails[]" value="`+allemails[i]+`" readonly></td>
								<td><input type="text" class="form-control f_po" name="phones[]" value="`+allphones[i]+`" readonly></td>
							  </tr>`;
				}
				$(".b_dy").html(emailStr);
		   }
		  });
	});

        $(function () {
            
            $(".tags").tagsinput()
            
            $('#template').change('click', function () {
                $('.preview').text('');
                var template = $(this).val();
                if (template != '') {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                        url: '{{ route("gettemplatecontent") }}',
                        type: 'POST',
                        data: {'template': template},
                        success: function (response) {
                            $('.preview').text(response);
                              CKEDITOR.replace( 'preview' );
    
                        }
                    });
                }
            });

            $('#notifications').validate({
                ignore: [],
                errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                errorElement: 'div',
                errorPlacement: function (error, e) {
                    e.parents('.form-group').append(error);
                },
                highlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
                    $(e).closest('.text-danger').remove();
                },
                success: function (e) {
                    // You can use the following if you would like to highlight with green color the input after successful validation!
                    e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
                    e.closest('.text-danger').remove();
                },
                rules: {
                    senders: {
                        required: true
                    },
                    campaign_title: {
                        required: true
                    },
                    template: {
                        required: true
                    },
                    preview: {
                        required: true
                    }
                },
                messages: {
                    senders: {
                        required: 'Please enter senders info'
                    },
                    campaign_title: {
                        required: 'Please enter title'
                    },
                    template: {
                        required: 'Please select template'
                    },
                    preview: {
                        required: 'Please enter title'
                    }
                },
            });
            imageRules();

        });

        function imageRules() {
            $(".logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }

        function imageRulesForVideo() {
            $(".video_logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }

    </script>

@endsection
