@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.3/css/fontawesome.min.css">
  <link rel="stylesheet" href="css/countrySelect.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
	<style>
     *{margin:0px; padding:0px;}
	 body{font-family: 'Poppins', sans-serif;}
	 .pa_bg{width:100%; height:150px; background-image:url(job-edit.png); background-repeat:no-repeat;}
	 .p_tag {
    color: #ababab;
}

.f_po1{
    border-radius: 0px;
    border: 2px dotted #ccc;
	}
.f_po {
    border-radius: 0px;
    height: 42px !important;
    border: 2px dotted #ccc;
}
.navbar-default{background:none; border:none;}
aside.left-panel{padding:0 0px; width:100%;}
.navbar .navbar-nav li > a .menu-icon{width:19px;}
.l_fom {
    width: 75%;
    float: left;
}
.r_wq {
    width: 25%;
    float: left;
}
.l_txt {
    color: #808080;
    font-weight: 500;
	padding:0px;
}
.ma_details {
    padding: 0px;
}
.se_tag {
    background: #f7f7f7;
    clear: both;
    padding: 26px;
	overflow:auto;
}
.q-tag {
    font-size: 16px;
}
.a-tag {
    color: #9c9c9c;
}
.btn_pr {
    float: right;
    color: #8f24f9;
    background: none;
    border: 2px solid #8f24f9;
}
.btn_pr:hover{
	    color: #8f24f9;
    background: none;
	border: 2px solid #8f24f9;
	}
.tab_ht {
    border: 1px solid #ccc;
}
.btn_edit {
    padding: 4px 15px;
    border-radius: 0px;
    background: #8f24f9;
    font-size: 13px;
}
.err_or {
    color: red;
}
.ro_qs {
    font-size: 19px;
    color: #8f24f9;
}
.la_w {
    width: 100%;
}
.for_gr {
    border: 1px solid #ccc;
    width: 100%;
    height: 34px;
	border-radius:0px;
}
.b_pr {
    border-radius: 0px;
    background: #8f24f9;
}
.b_pr:hover{
    border-radius: 0px;
    background: #8f24f9;
}
.w_del{width:22px;}
.chan_w{
    width: 70%;
    float: left;
}
.curr_ny{width:20%; float:left;}
.w_ctr{width:80%;}
.mi_edit {
    position: absolute;
    top: 150px;
}

.f_po13 {
    width: 85%;
}
.bt_remove {
    padding: 3px;
    top: 20px;
    border: 1px solid #ffc3ce !important;
    border-radius: 15px;
    background: none !important;
    box-shadow: none;
    color: #ff5576 !important;
    width: 15%;
    right: 0px;
    position: absolute;
}
._rdel {
    width: 25px;
}
.bt_remove:hover {
    padding: 3px;
    top: 20px;
    border: 1px solid #ffc3ce !important;
    border-radius: 15px;
    background: none !important;
    box-shadow: none;
    color: #ff5576 !important;
    width: 15%;
    right: 0px;
    position: absolute;
}
.b_tq {
    background: #8f24f9;
    border: none;
    border-radius: 0px;
    float: right;
}
.b_tq:hover{
    background: #8f24f9;
    border: none;
    border-radius: 0px;
    float: right;
}


@media screen and (min-width:320px) and (max-width:767px) {
  .l_tab {
    overflow-x: scroll;
}
.l_fom {
    width: 100%;
    float: left;
}
.country-select {
    width: 100%;
}
.chan_w {
    width: 100%;
    margin-top: 5px;
}
.bt_remove {
    top: -36px;
    width: 30%;
    right: 0px;
}
.f_po13 {
    width: 100%;
}
	
}

  </style>
  
@endsection

@section('content')
    {!! getBreadcrumbs(
               array(
               'dashboard'=>'Home',
               'admin.roles'=>'Roles',
               ''=>'Add New'
               ),'Add New Job Role'
            ) !!}
  
  

   <div class="container">
   
   <div class="se_tag">
   
   <div class="col-md-9 l_fom">

     <form method="POST" id="roles" action="{{ route('admin.addNewRoles') }}" accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
		{{ csrf_field() }}
		<input type="hidden" name="id" value="{{ $id }}">
        <div class="form-group">
          <label class="col-md-2 l_txt">Job Title<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
            <input type="text" class="form-control f_po" id="name_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}" name="name" value="{{ !empty(old('name')) ? old('name') : ((($record) && ($record->name)) ? $record->name : '') }}" placeholder="Name">
			@if ($errors->has('name'))
				<span class="text-danger help-block">{{ $errors->first('name') }}</span>
			@endif
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-2 l_txt">Company Name<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
            <input type="text" class="form-control f_po" id="companyname_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}" name="company_name" value="{{ !empty(old('company_name')) ? old('company_name') : ((($record) && ($record->company_name)) ? $record->company_name : '') }}" placeholder="Company Name">
			@if ($errors->has('company_name'))
				<span class="text-danger help-block">{{ $errors->first('company_name') }}</span>
			@endif
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-2 l_txt">Location<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
            
             <input class="col-md-6 form-control f_po" id="country_id" type="text" placeholder="Country" name="country" value="{{ (isset($record->country) ? $record->country:'') }}">
			 @if ($errors->has('country'))
			 <span
					class="text-danger help-block">{{ $errors->first('country') }}</span>
				@endif
			 <input class="col-md-6 form-control f_po"
												   id="city"
												   type="text"
												   placeholder="City"
												   name="city"
												   value="{{ (isset($record->city) ? $record->city : '') }}">
				@if ($errors->has('city'))
					<span class="text-danger help-block">{{ $errors->first('city') }}</span>
				@endif
			 	 
          </div>
        </div>
        
        <div class="form-group">
          <label class="col-md-2 l_txt">Currency<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
		  <?php
			$curencnyLists = curencnyLists();
			?>
			<select class="col-md-6 form-control f_po chan_w" name="currency_id"
					id="currency_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}">
				@if(count($curencnyLists)> 0)
					@foreach($curencnyLists AS $curencnyListKey=>$curencnyListValue)
						<option

							{{ ((($record) && ($record->currency_id ==$curencnyListKey )) ? 'selected' : '' )     }}

							value="{{ $curencnyListKey }}">{{ $curencnyListValue }}</option>
					@endforeach
				@endif

			</select>
                 
			<input class="form-control f_po w_ctr" style="width:50%;"
                                               id="salary_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="Salary"
                                               name="salary"
                                               value="{{ !empty(old('salary')) ? old('salary') : ((($record) && ($record->salary)) ? $record->salary : '') }}">
			@if ($errors->has('salary'))
				<span class="text-danger help-block">{{ $errors->first('salary') }}</span>
			@endif
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-2 l_txt">Experience<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
		  
			<select class="col-md-6 form-control f_po chan_w" name="experience_from" placeholder="Experience From"
												id="currency_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}">
				<option value="">Experience From</option>
				@for($i=0; $i<20;$i++)
					<option

						{{ ((($record) && ($record->experience_from ==$i )) ? 'selected' : '' )     }}

						value="{{ $i }}">{{ $i }}</option>
				@endfor
			</select>
                 
			<select class="col-md-6 form-control f_po chan_w" name="experience_from" placeholder="Experience From"
												id="currency_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}">
				<option value="">Experience To</option>
				@for($i=0; $i<20;$i++)
					<option

						{{ ((($record) && ($record->experience_from ==$i )) ? 'selected' : '' )     }}

						value="{{ $i }}">{{ $i }}</option>
				@endfor
			</select>
          </div>
        </div>
        <div class="form-group">
          <label class="col-md-2 l_txt">Job Type<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
		  <?php
			$role_job_types = role_job_types();
			?>
			<select class="form-control f_po" name="job_type"
					id="job_type_{{ ((($record) && ($record->id!='')) ? $record->id : 0 ) }}"
					required="required">

				@if(count($role_job_types)> 0)
					@foreach($role_job_types AS $role_job_type)
						<option
							{{ ((($record) && ($record->job_type ==$role_job_type )) ? 'selected' : '' )     }} value="{{ $role_job_type }}">{{ $role_job_type }}</option>
					@endforeach
				@endif
			</select>

			@if ($errors->has('job_type'))
				<span class="text-danger help-block">{{ $errors->first('job_type') }}</span>
			@endif
           </div>
        </div>
        
        <div class="form-group">
          <label class="col-md-2 l_txt">Joining Date<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
			<input class="form-control f_po datepicker_ui"
                                               id="joining_date_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="Joining Date"
                                               name="joining_date"
                                               value="{{ isset($record->joining_date ) && $record->joining_date != '' ? date('d-m-Y', strtotime($record->joining_date)) : '' }}"

                                            {{--                                               value="{{ !empty(old('joining_date')) ? old('joining_date') : ((($record) && ($record->joining_date)) ? $record->joining_date : '') }}"--}}
                                        >
                                        @if ($errors->has('joining_date'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('joining_date') }}</span>
                                        @endif
          </div>
        </div>
        
         <div class="form-group">
          <label class="col-md-2 l_txt">Industry<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
		  <input class="form-control f_po"
                                               id="industry_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="industry"
                                               name="industry"
                                               value="{{ !empty(old('industry')) ? old('industry') : ((($record) && ($record->industry)) ? $record->industry : '') }}">
                                        @if ($errors->has('industry'))
                                            <span class="text-danger help-block">{{ $errors->first('industry') }}</span>
                                        @endif
          </div>
        </div>
        
          <div class="form-group">
          <label class="col-md-2 l_txt">Role Details<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
		  <textarea class="form-control f_po1"
                                                  id="role_details_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                                  placeholder="Role Details"
                                                  name="role_details"
                                        >{{ !empty(old('role_details')) ? old('role_details') : ((($record) && ($record->role_details)) ? $record->role_details : '') }}</textarea>
				@if ($errors->has('role_details'))
					<span
						class="text-danger help-block">{{ $errors->first('role_details') }}</span>
				@endif
          </div>
        </div>
        
          <div class="form-group" id="roleExp">
          <label class="col-md-2 l_txt" id="roleExpectations">{{ (isset($roles_title[0]->role_expectation) && $roles_title[0]->role_expectation) ? $roles_title[0]->role_expectation : "Role Expectations" }}<span class="err_or">*</span></label>
		  <div class="controls-edit"> 
			@if(!empty($id)) <a href="javascript:void(0)" onclick="edititem(this);">Edit</a> @endif
		  </div>
          <div class="col-md-10 gr_p">
			<textarea class="form-control f_po13"
                                                  id="role_expectations_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                                  placeholder="Role Expectations"
                                                  name="role_expectations"
                                        >{{ !empty(old('role_expectations')) ? old('role_expectations') : ((($record) && ($record->role_expectations)) ? $record->role_expectations : '') }}</textarea>
			@if ($errors->has('role_expectations'))
				<span
					class="text-danger help-block">{{ $errors->first('role_expectations') }}</span>
			@endif
            
            <button class="btn btn-primary bt_remove" id="btnRoleExp">Remove&nbsp;<img src="{{ asset('images/delete-tab.png') }}" class="_rdel"></button>
          </div>
        </div>
        
        <div class="form-group" id="applyAfter">
          <label class="col-md-2 l_txt"id="afterApply">{{ (isset($roles_title[0]->after_apply) && $roles_title[0]->after_apply) ? $roles_title[0]->after_apply : "After Apply" }}<span class="err_or">*</span></label>
		  <div class="controls-edit1"> 
			@if(!empty($id)) <a href="javascript:void(0)" onclick="edititem1(this);">Edit</a> @endif
			</div>
          <div class="col-md-10 gr_p">
		  <textarea class="form-control f_po13" id="after_apply"
						  placeholder="After Apply"
						  name="after_apply"
				>{{ !empty(old('after_apply')) ? old('after_apply') : ((($record) && ($record->after_apply)) ? $record->after_apply : '') }}</textarea>
			@if ($errors->has('after_apply'))
				<span
					class="text-danger help-block">{{ $errors->first('after_apply') }}</span>
			@endif
            
             <button class="btn btn-primary bt_remove" id="btnAplyAfter">Remove&nbsp;<img src="{{ asset('images/delete-tab.png') }}" class="_rdel"></button>
          </div>
        </div>
        
			<div class="form-group" id="salaryInventive">
          <label class="col-md-2 l_txt" id="salaryIncentive">{{ (isset($roles_title[0]->salary_incentive) && $roles_title[0]->salary_incentive) ? $roles_title[0]->salary_incentive : "Salary Incentives" }}<span class="err_or">*</span></label>
		  <div class="controls-edit2"> 
			@if(!empty($id)) <a href="javascript:void(0)" onclick="edititem2(this);">Edit</a> @endif
			</div>
          <div class="col-md-10 gr_p">
		  <textarea class="form-control f_po13"
										  id="salary_incentives"
										  placeholder="After Apply"
										  name="salary_incentives"
								>{{ !empty(old('salary_incentives')) ? old('salary_incentives') : ((($record) && ($record->salary_incentives)) ? $record->salary_incentives : '') }}</textarea>
			@if ($errors->has('salary_incentives'))
				<span
					class="text-danger help-block">{{ $errors->first('salary_incentives') }}</span>
			@endif
             <button class="btn btn-primary bt_remove"id="btnSalaryIncentive">Remove&nbsp;<img src="{{ asset('images/delete-tab.png') }}" class="_rdel"></button>
          </div>
        </div>
        
        <div class="form-group">
          <button class="btn btn-primary b_tq"id="btnAddQuestion" type="button">Add Field</button>
        </div>
        <div id="allQuestion" class="form-group">
			@if(isset($roles_questions) && is_array($roles_questions) && count($roles_questions)>0)
				@foreach($roles_questions as $key => $value) 
				<?php //print_r($value);?>
				<div class="form-group" id="salaryInventive">
				<label class="col-md-2 l_txt">Question</label>
				<div class="col-md-10 gr_p">
					 <textarea class="form-control f_po13"
						   id="questions"
						   name="questions[]">{{ trim($value->questions) }}</textarea>
				</div>
				</div>
				@endforeach
			@endif
		</div>
		<div class="card-footer">
			<button type="submit" class="btn btn-primary btn-sm">
				<i class="fa fa-dot-circle-o"></i> Submit
			</button>
			<button type="reset" class="btn btn-danger btn-sm">
				<i class="fa fa-ban"></i> Reset
			</button>
		</div>
     </form>
     
     </div>
     
     <div class="col-md-3 r_wq hidden-xs">
        <img src="{{ asset('images/edit_mid.png') }}" class="mi_edit">
     </div>
       
   </div>
       
   </div>
  @endsection
@section('footerScripts')

    {{--    <script src="{{url('backend/modules/roles/js/roles.js')}}"></script>--}}
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.2-rc.1/js/select2.min.js"
            type="text/javascript"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/0.8.2/css/flag-icon.min.css" rel="stylesheet"/>

    <script>
        $(function () {
			
			$("#roleExpectations").on('dblclick', function(){
				
				$("roleExpectations").html('<input type="text" style="width:129px;" name="role_expectation" value="Role Expectations">');
			});
			$("#btnRoleExp").on('click', function(){
				$("#roleExp").remove()
			});
			$("#btnAplyAfter").on('click', function(){
				$("#applyAfter").remove()
			});
			$("#btnSalaryIncentive").on('click', function(){
				$("#salaryInventive").remove()
			});		
			$("#btnAddQuestion").on('click', function(){
				var html = `<div class="form-group" id="removequestion">
                                    <div class="col-md-2 l_txt">
                                        <label for="hf-email" class=" form-control-label">Question</label>
                                    </div>
                                    <div class="col-md-10 gr_p">
										 <textarea class="form-control f_po13"
                                               id="questions"
                                               type="text"
                                               name="questions[]">
											   </textarea>
                                    </div>
                                </div>`;
								
								
				$("#allQuestion").append(html);
			});
            $(".datepicker_ui").datepicker({
                dateFormat: 'dd-mm-yy',
                changeMonth: true,
                changeYear: true,
            });

            $('.select2').select2();

            $('.select2_country').select2({
                placeholder: '-Select Country-',
                templateResult: formatCountry,
                templateSelection: formatCountry
            });

            function formatCountry(country) {
                if (!country.id) {
                    return country.text;
                }


                console.log(country)

                // 'code'

                var $country = $(
                    '<span class="flag-icon flag-icon-' + country.id.toLowerCase() + ' flag-icon-squared"></span>' + '<span style="margin-left:10px;">' + country.text + '</span>'
                );
                return $country;
            };

        });
    </script>

    <script>
	function edititem(element) {
		var lebel = $("#roleExpectations").text();
		$("#roleExpectations").html('<input type="text" style="width:129px;" name="roleexpec" id="roleexpec" value="'+lebel+'">');
		$(".controls-edit").html('<a href="javascript:void(0)" onclick="updateheading()">Update</a>');
	}
	function updateheading(){
		var roleexpec = $("#roleexpec").val();
		$.ajax({
		  url: "{{ route('admin.addRoleTitle') }}",
		  cache: false,
		  method:'post',
		  data:{'role_id':{{ $id }},'title':roleexpec, "_token": "{{ csrf_token() }}"},
		  success: function(html){
			$(".controls-edit").html('<a href="javascript:void(0)" onclick="edititem()">Edit</a>');
			$("#roleExpectations").text(roleexpec);
		  }
		});

	}
	function edititem1(element) {
		var lebel = $("#afterApply").text();
		$("#afterApply").html('<input type="text" style="width:129px;" name="after_apply" id="after_apply" value="'+lebel+'">');
		$(".controls-edit1").html('<a href="javascript:void(0)" onclick="updateheading1()">Update</a>');
	}
	function updateheading1(){
		var after_apply = $("#after_apply").val();
		$.ajax({
		  url: "{{ route('admin.addRoleTitle') }}",
		  cache: false,
		  method:'post',
		  data:{'role_id':{{ $id }},'flag':1,'title':after_apply, "_token": "{{ csrf_token() }}"},
		  success: function(html){
			$(".controls-edit1").html('<a href="javascript:void(0)" onclick="edititem1()">Edit</a>');
			$("#afterApply").text(after_apply);
		  }
		});

	}
	function edititem2(element) {
		var lebel = $("#salaryIncentive").text();
		$("#salaryIncentive").html('<input type="text" style="width:129px;" name="salary_incentive" id="salary_incentive" value="'+lebel+'">');
		$(".controls-edit2").html('<a href="javascript:void(0)" onclick="updateheading2()">Update</a>');
	}
	function updateheading2(){
		var salary_incentive = $("#salary_incentive").val();
		$.ajax({
		  url: "{{ route('admin.addRoleTitle') }}",
		  cache: false,
		  method:'post',
		  data:{'role_id':{{ $id }},'flag':2,'title':salary_incentive, "_token": "{{ csrf_token() }}"},
		  success: function(html){
			$(".controls-edit2").html('<a href="javascript:void(0)" onclick="edititem2()">Edit</a>');
			$("#salaryIncentive").text(salary_incentive);
		  }
		});

	}
        $(function () {

            $(document.body).on('change', "#question_type_options", function (e) {

                if ($(this).val() == 'radio') {
                    $('.optionsdiv').show();
                } else {
                    $('.optionsdiv').hide();
                }
            });

            $('#roles').validate({
                ignore: [],
                errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                errorElement: 'div',
                errorPlacement: function (error, e) {
                    e.parents('.form-group').append(error);
                },
                highlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
                    $(e).closest('.text-danger').remove();
                },
                success: function (e) {
                    // You can use the following if you would like to highlight with green color the input after successful validation!
                    e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
                    e.closest('.text-danger').remove();
                },
                rules: {
                    name: {
                        required: true
                    },
                    country_id: {
                        required: true
                    },
                    currency_id: {
                        required: true
                    },
                    salary: {
                        required: true
                    },
                    job_type: {
                        required: true
                    },
                    joining_date: {
                        required: true
                    },
                    industry: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: 'Please enter name'
                    },
                    country_id: {
                        required: "Select Country"
                    },
                    currency_id: {
                        required: "Select Currency"
                    },
                    salary: {
                        required: "Enter salary"
                    },
                    job_type: {
                        required: "Select Job Type"
                    },
                    joining_date: {
                        required: "Select Joining date"
                    },
                    industry: {
                        required: "Enter Industry"
                    },
                },
            });


            $('.questionsForm').each(function () {
                $($(this)).validate({
                    ignore: [],
                    errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                    errorElement: 'div',
                    highlight: function (element) {
                        jQuery(element).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (element) {
                        jQuery(element).closest('.form-group').removeClass('has-error');
                    },
                    errorPlacement: function (error, element) {
                        if (element.parent('.input-group').length) {
                            error.insertAfter(element.parent());
                        } else {
                            error.insertAfter(element);
                        }
                    },
                    rules: {
                        question: {
                            required: true
                        },
                        // option1: {
                        //     required: true
                        // },
                        // option2: {
                        //     required: true
                        // },
                        question_type: {
                            required: true
                        }


                    },
                    messages: {

                        question: {
                            required: 'Please enter question'
                        },
                        // option1: {
                        //     required: 'Please enter option'
                        // },
                        // option2: {
                        //     required: 'Please enter option'
                        // },
                        question_type: {
                            required: 'Select question type'
                        }


                    },
                    submitHandler: function (form) {

                        return true;
                    }
                });

            })

        });


    </script>

@endsection
