@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
 <style>
     *{margin:0px; padding:0px;}
	 body{font-family: 'Poppins', sans-serif;}
	 .l_jobs{ width:100%;}
.li_st {
    box-shadow: 0 1px 1px 0 rgb(0 0 0 / 5%), 0 1px 2px 0 rgb(0 0 0 / 10%), 0 2px 20px 0 rgb(0 0 0 / 20%);
    height: 184px;
    margin: auto;
    width: 80%;
    margin-top: 7px;
    padding: 9px;
	background:#fff;
    margin-bottom: 7px;
}
.hidden{display:none;}
.ico_s {
    width: 18px;
}
.dropdown-item:hover {background:none;}
.h_ui {
    font-size: 17px;
    font-weight: 600;
    color: #7b7b7b;
}
.li_jobs {
    width: 185px;
}
.com_ny {
    color: #888;
    font-weight: 500;
}
.i_list {
    font-weight: 500;
    color: #888;
}
.no_tw1 {
    width: 16px;
}
.no_tw {
    color: #8a8a8a;
    font-size: 12px;
    margin-top: 6px;
}
.clo_k{width:13px;}
.bladge_e {
    background: #dadada;
    width: 98px;
    border-radius: 5px;
    font-size: 11px;
    padding: 4px 5px 4px;
    margin-left: 15px;
    text-align: center;
}
.edi_li {
    position: absolute;
    right: 2px;
    opacity: 0.9;
    top: 5px;
	cursor:pointer;
}
.edi_li1 {
    position: absolute;
    right: 2px;
    opacity: 0.9;
    top: 5px;
	cursor:pointer;
}
.edi_li2 {
    position: absolute;
    right: 2px;
    opacity: 0.9;
    top: 5px;
	cursor:pointer;
}
.dot_s {
    width: 8px;
}
.li_dip {
    right: 0px;
    position: absolute;
}
.li_dip1 {
    right: 0px;
    position: absolute;
}
.li_dip2 {
    right: 0px;
    position: absolute;
}

.li_qw {
    background: #565656;
    width: 85px;
    padding: 5px;
    list-style: none;
    z-index: 9999999;
}
.cl_t {
    font-size: 22px;
    font-weight: 600;
    color: #8f24f9;
}
.b_pr {
    color: #333;
    float: right;
    margin-top: 13px;
    border: 2px solid #8f24f9;
    background: none;
}
.b_pr:hover {
    color: #333;
    border: 2px solid #8f24f9;
    background: none;
}
.li_qw:hover{
	background: #828282;
}
.li_qw a {
    display: block;
    color: #fff;
    text-decoration: none;
}
.li_qw a:hover{color:#565656;}


@media screen and (min-width:320px) and (max-width:767px) {
 .li_st {
    height: auto;
    width: 100%;
    margin-top: 7px;
    padding: 2px;
    margin-bottom: 7px;
}	
}

  </style>
 

@endsection

@section('content')

    {!! getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              ''=>'Job Roles'
              ),'Job Roles'
           ) !!}  
  

   <div class="container">
   
     <div class="col-md-12 header_p">
        <div class="col-md-6 l_st">
          <h2 class="cl_t"></h2>
        </div>
        <div class="col-md-6 r_st">
          <button class="btn btn-primary b_pr"><a href="{{route('admin.addNewRoles')}}">Add Roles</a></button>
        </div>
     </div>
   
       
		@if(count($records)>0)
            @foreach($records as $item)
		 @php 
		$datetime1 = new DateTime($item->created_at);
		$datetime2 = new DateTime(date("Y-m-d h:i:s"));
		$difference = $datetime1->diff($datetime2);
		$dayAgo = $difference->d;
		@endphp
		<div class="col-md-12 l_jobs">
          <div class="li_st">
              <div class="col-md-9 l_lit">
                <h2 class="h_ui">{{ $item->name }}</h2>
                <p class="com_ny">{{ $item->company_name }}</p>
                <span class="i_list"><img src="{{ asset('images/briefcase.png') }}" class="ico_s">&nbsp;&nbsp;{{ $item->experience_from }}-{{ $item->experience_to }}Years</span>
                <span class="i_list"><img src="{{ asset('images/doller.png') }}" class="ico_s">&nbsp;&nbsp;{{ $item->salary }}</span>
                <span class="i_list"><img src="{{ asset('images/location.png') }}" class="ico_s">&nbsp;&nbsp;{{ $item->city }}</span>
                <span class="i_list"><img src="{{ asset('images/joining-date.png') }}" class="ico_s">&nbsp;&nbsp;{{ date('d-m-Y', strtotime($item->joining_date)) }}</span>
                <p class="no_tw"><img src="{{ asset('images/note.png') }}" class="no_tw1">&nbsp;&nbsp;{{ substr($item->role_details, 0,100) }}...</p>
                <div class="bladge_e"><img src="{{ asset('images/time.png') }}" class="clo_k">&nbsp;Days Ago {{ $dayAgo }}</div>
              </div>
              <div class="col-md-3 l_img">
                 <div class="edi_li">
                 <img src="{{ asset('images/dots.png') }}" class="dot_s">
                 <ul class="li_dip" style="display:none;">
                   <li class="li_qw"><a href="{{ route('admin.listNewRoles',['id'=>$item->id]) }}" class="ch_st">View</a></li>
				   <li class="li_qw"><a href="{{ route('admin.addNewRoles',['id'=>$item->id]) }}" class="ch_st">Edit</a></li>
				   <form method="POST" id="roles"  action="{{ route('admin.roles') }}" accept-charset="UTF-8" class="form-horizontal"  style="display:inline">
					{{ csrf_field() }}
                     <input type="hidden" name="id" value="{{ $item->id }}"/>

                   <li class="li_qw"><button type="submit" class="dropdown-item" title="Delete Record"
                                                                    onclick="return confirm(&quot;Confirm delete?&quot;)" style="color:#fff;margin-left:-24px;">Delete</button></li>
				   </form>
                 </ul>
                 </div>
                <img src="{{ asset('images/lis_jobs.png') }}" class="li_jobs">
              </div>
          </div>
		  </div>
          @endforeach
			@else
				<div class="col-md-9 l_lit">No records found</div>
			
			@endif     
			<div class="row" style="margin-top:15px; margin-bottom:15px;">
                <div class="col-md-6">
                    <div class="dataTables_info p-t-10" id="editable-datatable_info" role="status"
                         aria-live="polite">Showing {{ $records->firstItem() }}
                        to {{ $records->lastItem() }} of {{ $records->total() }} entries
                    </div>
                </div>
                <div class="col-md-6 text-right">
                    <div class="dataTables_paginate paging_simple_numbers" id="editable-datatable_paginate">
                        {!! $records->appends(['filters' => Request::get('filters'),'search' => Request::get('search')])->render() !!}
                    </div>
                </div>
            </div>
   </div>
			
   
@endsection
@section('footerScripts')
<script>
      $(".edi_li").click(function(){
  $(".li_dip").fadeToggle();
});
      $(".edi_li1").click(function(){
  $(".li_dip1").fadeToggle();
});
      $(".edi_li2").click(function(){
  $(".li_dip2").fadeToggle();
});
   </script>
@endsection
