@extends('backend.layout')
@section('title', $title)

@section('headerStyles')  
  <style>
     *{margin:0px; padding:0px;}
	 body{font-family: 'Poppins', sans-serif;}
	 .pa_bg{width:100%; height:150px; background-image:url(job-details-bg.png); background-repeat:no-repeat;}
	 .p_tag {
    color: #ababab;
}
.ma_details {
    padding: 0px;
}
.se_tag {
    background: #f7f7f7;
    clear: both;
    padding: 26px;
	overflow:auto;
}
.q-tag {
    font-size: 16px;
}
.a-tag {
    color: #9c9c9c;
}
.btn_pr {
    float: right;
    color: #8f24f9;
    background: none;
    border: 2px solid #8f24f9;
}
.btn_pr:hover{
	    color: #8f24f9;
    background: none;
	border: 2px solid #8f24f9;
	}
.tab_ht {
    border: 1px solid #ccc;
}
.btn_edit {
    padding: 4px 15px;
    border-radius: 0px;
    background: #8f24f9;
    font-size: 13px;
}
.ro_qs {
    font-size: 19px;
    color: #8f24f9;
}
.la_w {
    width: 100%;
}
.for_gr {
    border: 1px solid #ccc;
    width: 100%;
    height: 34px;
	border-radius:0px;
}
.b_pr {
    border-radius: 0px;
    background: #8f24f9;
}
.b_pr:hover{
    border-radius: 0px;
    background: #8f24f9;
}
.w_del{width:22px;}


  </style>
@endsection

@section('content')

    {!! getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              ''=>'List Job Role'
              ),'List Job Role'
           ) !!}  
    
<br>
   <div class="container">
	@if(is_array($record) && count($record)>0)
	@php
		$datetime1 = new DateTime($record[0]['created_at']);
		$datetime2 = new DateTime(date("Y-m-d h:i:s"));
		$difference = $datetime1->diff($datetime2);
		
		$dayAgo = $difference->d;
		$monthAgo = $difference->m;
		if($monthAgo!==0) 
		$dayAgo = $monthAgo * 30 + $dayAgo;
		
	
	@endphp
	   <div class="col-md-12 ma_details">
		  <h3 class="m_ht">{{ $record[0]['name'] }}</h3>
		  <p class="p_tag">{{ $record[0]['company_name'] }}</p>
		  <p class="p_tag">Posted: {{ $dayAgo }} days ago</p>
	   </div>
	   
	   <div class="se_tag">
		  <p class="q-tag">Job description</p>
		  <p class="a-tag">{{ $record[0]['role_expectations'] }}</p>
			 
				   <p class="q-tag">Role Details</p>
				  <p class="a-tag">{{ $record[0]['role_details'] }}</p>
			 
			  <p class="q-tag">Salary Incentives</p>
		  <p class="a-tag">{{ $record[0]['salary_incentives'] }}</p>

		<!--<button class="btn btn-danger btn_pr">Add Field</button>-->

			 
	   </div>
	@endif   
   @if($id!='')

	@if (Session::has('flash_message'))
		<br/>
		<div class="alert alert-success alert-dismissable">
			<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
			<strong>{{ Session::get('flash_message' ) }}</strong>
		</div>
	@endif
	<div class="row">
		<div class="col-md-8 grid-margin stretch-card">
			<div class="card">
				<div class="card-body">
					<p class="card-title mb-0">Roles Questions</p>

					<div class="table-responsive">

						<table class="table table-hover">
							<thead>
							<tr>
								<th>#</th>
								<th>Question</th>
								<th>Question type</th>
								<th>Option1</th>
								<th>Option2</th>
								<th>Action</th>
							</tr>
							</thead>
							<tbody>
							@if(count($questions)> 0)
								@foreach($questions AS $question)
									<tr>
										<td>{{ $loop->iteration }}</td>
										<td>{{ $question->question }}</td>
										<td>{{ $question->question_type }}</td>
										<td>{{ ($question->question_type=='radio') ? $question->option1 : '-' }}</td>
										<td>{{ ($question->question_type=='radio') ? $question->option2 : '-' }}</td>
										<td>

											<!-- Button trigger modal -->


											<form method="post"
												  action="{{ route('admin.addNewQuestions') }}"
												  onsubmit="return confirm('Are you sure Delete?')">
											@csrf

											<!-- Button to Open the Modal -->
												<button type="button" class="btn btn-primary btn_edit" style="border-radius: 3px;"
														data-toggle="modal"
														data-target="#exampleModal{{ $loop->iteration }}">
													Edit
												</button>

												<input type="hidden" name="action"
													   value="remove">
												<input type="hidden" name="id"
													   value="{{ $question->id }}">
												<input type="hidden" name="role_id"
													   value="{{ $id }}">

												<button type="submit" style="border:0px">
													<img  src="{{ asset('images/delete-tab.png') }}" border="0" class="w_del">
												</button>
												
											</form>

											<!-- Modal -->
											<div class="modal fade"
												 id="exampleModal{{ $loop->iteration }}"
												 tabindex="-1" role="dialog"
												 aria-labelledby="exampleModalLabel"
												 aria-hidden="true">
												<div class="modal-dialog" role="document">
													<div class="modal-content">
														<div class="modal-header">
															<h5 class="modal-title"
																id="exampleModalLabel">Update
																Questions</h5>
															<button type="button" class="close"
																	data-dismiss="modal"
																	aria-label="Close">
																<span
																	aria-hidden="true">&times;</span>
															</button>
														</div>
														<div class="modal-body">

															<form method="post"
																  action="{{ route('admin.addNewQuestions') }}"
																  id="questionsForm"
																  class="questionsForm">
																@csrf

																<input type="hidden"
																	   name="action"
																	   value="edit">
																<input type="hidden" name="id"
																	   value="{{ $question->id }}">

																@include('backend.roles.questions-form')

																<div class="form-group">
																	<button type="submit"
																			class="btn btn-outline-primary">
																		Update
																	</button>
																</div>

															</form>
														</div>
														<div class="modal-footer">
															<button type="button"
																	class="btn btn-secondary"
																	data-dismiss="modal">Close
															</button>
														</div>
													</div>
												</div>
											</div>


										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td colspan="4">No Data Found</td>
								</tr>

							@endif


							</tbody>
						</table>
						<?php
						$question = '';
						?>
					</div>


				</div>
			</div>
		</div>
		@endif
      <!--<div class="col-md-3 r_box">
        <h3 class="ro_qs">Create Questions</h3>
        
        <form method="post" action="{{ route('admin.addNewQuestions') }}" id="questionsForm" class="questionsForm">
			@csrf

			<input type="hidden" name="action" value="add">

			@include('backend.roles.questions-form')

			<div class="form-group">
				<button type="submit" class="btn btn-outline-primary">Save</button>
			</div>


		</form>
        
        
      </div>-->
   </div>
       
   </div>
@endsection
@section('footerScripts')
@endsection
