@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.3/css/fontawesome.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  
<style>
     *{margin:0px; padding:0px;}
	 body{font-family: 'Poppins', sans-serif;}
	 .pa_bg{width:100%; height:150px; background-image:url(setting.png); background-repeat:no-repeat; background-size:cover;}
    .f_po {
    border-radius: 0px;
    height: 42px;
    border: 2px dotted #ccc;
}
.err_or {
    color: red;
}
.l_txt {
    color: #808080;
    font-weight: 500;
    padding: 0px;
}
.navbar-default {
    width: 100% !important;
     background-color: #272c33 !important;
     border-color: #272c33 !important;
}
aside.left-panel {
    padding: 0 0px;

}
.navbar .navbar-nav li > a .menu-icon {
    width: 16px;
}

.profile-pic {
    width:100%;
    height: 100%;
    display: block;
}

.file-upload {
    display: none !important;
}
.circle {
    border-radius: 50%;
    overflow: hidden;
    width: 133px;
    height: 133px;
    border: 4px dotted rgb(222 222 222);
    position: absolute;
    top: 72px;
}
.l_fom {
    margin-top: 26px;
}
img {
    max-width: 100%;
    height: auto;
}
.cler_b {
    clear: both;
}
.gr_p {
    clear: both;
}
.p-image {
    z-index: 99999;
    position: absolute;
    top: 167px;
    color: #666666;
    transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
}
.p-image:hover {
  transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
}
.upload-button {
  font-size: 1.2em;
}
.gr_p.da_sq {
    margin-left: 150px;
    margin-top: -34px;
}
.upload-button:hover {
  transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
  color: #999;
}
.columns {
    width: 100%;
    margin: auto;
    text-align: center;
    margin-left: 380px;
}
img.car_btn.upload-button {
    width: 30px;
    background: #fff;
    padding: 1px;
    border-radius: 50%;
}
.up_lod {
    position: absolute;
    right: 35px;
    width: 316px;
    top: 139px;
}
.bt_rq:hover {
    background: #8f24f9;
}
.bt_rq {
    margin-top: 267px;
    background: #8f24f9;
    border: none;
    padding: 7px 29px;
	border-radius:3px;
}

.pa_bg {
    width: 100%;
    height: 150px;
    background-image: url(http://localhost/interviewtool/public/images/setting.png);
    background-repeat: no-repeat;
    background-position: right;
    background-size: cover;
}

@media screen and (min-width:320px) and (max-width:767px) {
  .columns {
    margin-left: 84px;
}	
.gr_p.da_sq {
    margin-left: 0px;
    margin-top: 0px;
}
}

  </style>
  
@endsection

@section('content')
   
<div class="col-md-12 pa_bg">

</div>

<div class="container">
  <div class="col-md-12 l_fom">
	@if (Session::has('flash_message'))
		<br/>
		<div class="alert alert-success alert-dismissable">
			<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
			<strong>{{ Session::get('flash_message' ) }}</strong>
		</div>
	@endif
	<form method="POST" id="settings" action="{{ route('admin.settings') }}"
                                  accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
     {{ csrf_field() }}
        <div class="form-group">
          <label class="col-md-2 l_txt">Company Name<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p da_sq">
		  <input class="form-control f_po" id="name" type="text"
                                               placeholder="Company Name"
                                               name="title"
                                               value="{{ !empty(old('title')) ? old('title') : ((($record) && ($record->title)) ? $record->title : '') }}">
			@if ($errors->has('title'))
				<span class="text-danger help-block">{{ $errors->first('title') }}</span>
			@endif
            
          </div>
        </div>
		
		
        
        <div class="form-group">
		
          <label class="col-md-2 l_txt">Logo<span class="err_or">*</span></label>
          <div class="col-md-10 gr_p">
              <div class="small-12 medium-2 large-2 columns">
                 <div class="circle">
                   <!-- User Profile Image -->
				   @if(($record) && ($record->logo))
					<div class="logo_{{ $record->id }}">
						<img src="{{ asset('uploads/settings/'.$record->logo) }}" class="profile-pic" width="100" height="100"/>
					</div>
					@endif
                   
            
                   <!-- Default Image -->
                   <!-- <i class="fa fa-user fa-5x"></i> -->
                 </div>
                 <div class="p-image">
                   <!--<i class="fa fa-camera upload-button fa_camera"></i>-->
                   <img src="{{ asset('images/Camera-Icon.png') }}" class="car_btn upload-button">
					<input class="file-upload {{ (($record) && ($record->logo)) ? '' : 'logo'}}"
                                               id="logo" type="file" name="logo" >
					@if ($errors->has('logo'))
						<span class="text-danger">{{ $errors->first('logo') }}</span>
					@endif
                 </div>
              </div>
          </div>
        </div>
		<div class="form-group">
		<div class="col-md-12">
            <button class="btn btn-primary bt_rq cler_b" type="submit">Save</button>
	      </div>
        </div>
     </form>
     
     <img src="{{ asset('images/up_lob.png') }}" class="up_lod hidden-xs">
     
     </div>
</div>

@endsection
@section('footerScripts')


    <script>
        $(function () {
            $('.delete_logo').on('click', function () {
                var image = $(this).attr('id');
                if (image != '') {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                        url: '/admin/ajax/deletelogo',
                        type: 'POST',
                        data: {'image': image},
                        success: function (response) {
                            $('.logo_' + image).remove();
                            $('#logo').addClass('logo');
                            imageRules();
                        }
                    });
                }
            });

      $('.delete_video_logo').on('click', function () {
                var image = $(this).attr('id');
                if (image != '') {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                        url: '/admin/ajax/deletevideologo',
                        type: 'POST',
                        data: {'image': image},
                        success: function (response) {
                            $('.video_logo_' + image).remove();
                            $('#video_logo').addClass('video_logo');
                            //imageRulesForVideo();
                        }
                    });
                }
            });

            $('#settings').validate({
                ignore: [],
                errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                errorElement: 'div',
                errorPlacement: function (error, e) {
                    e.parents('.form-group').append(error);
                },
                highlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
                    $(e).closest('.text-danger').remove();
                },
                success: function (e) {
                    // You can use the following if you would like to highlight with green color the input after successful validation!
                    e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
                    e.closest('.text-danger').remove();
                },
                rules: {
                    title: {
                        required: true
                    }
                },
                messages: {
                    title: {
                        required: 'Please enter title'
                    }
                },
            });
            imageRules();

        });

        function imageRules() {
            $(".logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }
   function imageRulesForVideo() {
            $(".video_logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }
	 $(document).ready(function() {

    
    var readURL = function(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('.profile-pic').attr('src', e.target.result);
            }
    
            reader.readAsDataURL(input.files[0]);
        }
    }
    

    $(".file-upload").on('change', function(){
        readURL(this);
    });
    
    $(".upload-button").on('click', function() {
       $(".file-upload").click();
    });
});
    </script>

@endsection
