 @extends('backend.layout')
@section('title', $title)

@section('headerStyles')

    <link href="https://cdnjs.cloudflare.com/ajax/libs/video.js/7.10.2/video-js.min.css" rel="stylesheet">

    <link href="https://unpkg.com/@videojs/themes@1.0.1/dist/sea/index.css" rel="stylesheet" />

    <style>
        video{
            background: #f2f2f2;
            border: 1px solid #000000;
        }
        .tp_f {
            margin-left: 24px !important;
            color: #ed087f;
            text-transform: uppercase;
            font-size: 20px;
        }
        .bp_f {
            margin-left: 25px;
            margin-top: 15px;
            text-transform: capitalize;
            color: #7d7272;
        }


        @media screen and (min-width:320px) and (max-width:767px) {
            .tp_f {
                margin-left: 24px !important;
                color: #ed087f;
                text-transform: uppercase;
                font-size: 19px;
            }
            .bp_f {
                margin-left: 25px;
                margin-top: 15px;
                text-transform: capitalize;
                color: #7d7272;
            }
            .c_w{width:93% !important;}
        }

    </style>

@endsection

@section('content')

    {!! getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              'admin.completedusers'=>'Completed Users',
              ''=>'Completed User Info'
              ),'Completed User Info'
           ) !!}

    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">

                <div class="col-lg-12">
                    @if (Session::has('flash_message'))
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong>{{ Session::get('flash_message' ) }}</strong>
                        </div>
                    @endif
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Completed User Info</strong>

                        </div>
                        <div class="card-body table-responsive">


                            <table class="table table-bordered table-hover">

                                <tr>
                                    <td>
                                        Name
                                    </td>
                                    <td>
                                        {{ isset( $userInfo)? $userInfo->name : '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Email
                                    </td>
                                    <td>
                                        {{isset( $userInfo)? $userInfo->email : ''}}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Mobile
                                    </td>
                                    <td>
                                        +{{isset( $userInfo)?   $userInfo->country_code."-".$userInfo->mobile : '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Role
                                    </td>
                                    <td>
                                        {{ isset( $userInfo->getRole)?  $userInfo->getRole->name : '' }}
                                    </td>
                                </tr>

                                @foreach($questions as $question)

                                    <tr>
                                        <td>
                                            {{ $question->question }}
                                        </td>
                                        <td>
                                            {{ isset($userInfo) ? getUserAnswers($question->id,$userInfo->id,$question->flag) :'' }}
                                        </td>
                                    </tr>


                                @endforeach

<!-- 
                                 <tr>
                                        <td>
                                            Resume
                                        </td>
                                        <td>

                                            @if($userInfo->getCandidate->html_code)
                                            {!! $userInfo->getCandidate->html_code !!}


@endif

                                           <?php
                                        //   dump($userInfo->getCandidate->html_code);
                                           ?>
                                        </td>
                                    </tr> -->





                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>


                      <div class="row">
                          <div class="col-md-12">
                              
                                @if(isset($candidateVideos) && count($candidateVideos)> 0)
                                  @foreach($candidateVideos AS $vide)

                                      <?php
                                                                     //             dump($vide);
                                      ?>

                                      <div class="row">
                                          <div class="col-md-6">
                                              <h2 class="tp_f">
                                                  {{  $vide->name }}
                                              </h2>
                                              <h6 class="bp_f">
                                                  {{  isset($vide->video_name)?  $vide->video_name : '' }}
                                              </h6>

                                              @if(isset($vide->video_url_file))

                                                  <video class="i_fram video-js vjs-theme-sea m-3 c_w" controls
                                                         width="397"
                                                         height="264"
                                                         preload="none"
                                                         poster="https://media.swncdn.com/via/5793-istockgetty-images-pluspattadis-walarput.jpg"
                                                         id="my-video_{{$vide->id}}">
                                                      <source src="{{ $vide->video_url_file }}"
                                                              type="video/webm">
                                                      Your browser does not support the video tag.
                                                  </video>

                                              @endif




                                          </div>
                                          <div class="col-md-6">

                                              <h2 class="tp_f">
                                                  {{  $vide->name }}
                                              </h2>
                                              <h6 class="bp_f">
                                                  {{  isset($vide->video_name)?  $vide->video_name : '' }}
                                              </h6>
                                              <video class="i_fram video-js vjs-theme-sea m-3 c_w" controls
                                                     width="397"
                                                     height="264"
                                                     preload="none"
                                                     poster="https://media.swncdn.com/via/5793-istockgetty-images-pluspattadis-walarput.jpg"
                                                     id="my-video_user_{{$vide->id}}"

                                              >
                                                  <source src="{{ $vide->video_file_url }}" type="video/webm">
                                                  Your browser does not support the video tag.
                                              </video>

                                          </div>
                                      </div>





                                     

                                  @endforeach
                              @endif
                          </div>
                      </div>


                        <div class="card-header">
                            <strong class="card-title">Role based questions</strong>

                        </div>
                        <div class="card-body">


                            <table class="table table-bordered table-hover">

                                @if(count($role_questions)>0)
                                    @foreach($role_questions as $role_question)

                                        <tr>
                                            <td>
                                                {{ $role_question->question }}
                                            </td>
                                            <td>
                                                {{ getRoleAnswers($role_question->id,$userInfo->id) }}
                                            </td>
                                        </tr>

                                    @endforeach
                                @else
                                    <tr>
                                        <td>
                                            No Data Found
                                        </td>
                                    </tr>

                                @endif


                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>


                    </div>
                </div>

            </div>

        </div><!-- .animated -->
    </div><!-- .content -->

@endsection
@section('footerScripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/7.10.2/video.min.js"></script>
    <script src="/js/vidoejs.logo.js"></script>

    <?php
    $get_settings = get_settings();

    $vidoeLogoUrl = '/Hirextra_logo.png';

    if (!empty($get_settings)){
        $vidoeLogoUrl =  $get_settings->video_logo_url;
    }

    //dump($get_settings);
    ?>

    <script>

    $('.i_fram').each(function(){
        var vidoeFrameId = $(this).attr('id');


          var playerCat = videojs(vidoeFrameId);
            playerCat.logo({
                image: '{{ $vidoeLogoUrl }}',
                position: 'top-right',
                fadeDelay : '99999999999',
                width : '50',
            });

    })


    </script>

@endsection
