@extends('backend.layout')
@section('title', $title)

@section('headerStyles')

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            display: none;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #3c8dbc;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

@endsection

@section('content')

    {!! getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              'admin.incompleteusers'=>'Incompleted Users',
              ''=>'Incompleted User Info'
              ),'Incompleted User Info'
           ) !!}

    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">

                <div class="col-lg-12">
                    @if (Session::has('flash_message'))
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong>{{ Session::get('flash_message' ) }}</strong>
                        </div>
                    @endif
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Incompleted User Info</strong>

                        </div>
                        <div class="card-body">


                            <table class="table table-bordered table-hover">

                                <tr>
                                    <td>
                                        Name
                                    </td>
                                    <td>
                                        {{ isset($userInfo) ? $userInfo->name : '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Email
                                    </td>
                                    <td>
                                        {{ isset($userInfo) ? $userInfo->email : '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Mobile
                                    </td>
                                    <td>
                                        +{{ isset($userInfo) ? $userInfo->country_code."-".$userInfo->mobile : '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Role
                                    </td>
                                    <td>
                                        {{isset($userInfo) ? $userInfo->getRole->name : '' }}
                                    </td>
                                </tr>

                                @foreach($questions as $question)

                                    <tr>
                                        <td>
                                            {{ $question->question }}
                                        </td>
                                        <td>
                                            {{ isset($userInfo) ? getUserAnswers($question->id,$userInfo->id,$question->flag) : '' }}
                                        </td>
                                    </tr>


                                @endforeach


                                @if(isset($userInfo) && count($userInfo->getRecords)> 0)
                                    @foreach($userInfo->getRecords AS $vide)

                                        <?php
                                        //                                        dump($vide->getRefVideo);
                                        ?>

                                        <tr>
                                            <td>
                                                <h2>
                                                    {{ isset($vide->getCategory)? $vide->getCategory->name : '' }}
                                                </h2>
                                                <h6>
                                                    {{  isset($vide->getRefVideo->video_name) ? $vide->getRefVideo->video_name : '' }}
                                                </h6>

                                                <video class="i_fram" width="100%" height="240" controls>
                                                    <source src="{{ $vide->getRefVideo->video_url_file }}"
                                                            type="video/webm">
                                                    Your browser does not support the video tag.
                                                </video>
                                                {{--                                                <iframe width="100%" height="240" class="i_fram"--}}
                                                {{--                                                        src="{{ $vide->getRefVideo->video_url_file }}"--}}
                                                {{--                                                        frameborder="0"--}}
                                                {{--                                                        allow="accelerometer;  clipboard-write; encrypted-media; gyroscope; picture-in-picture"--}}
                                                {{--                                                        allowfullscreen></iframe>--}}
                                            </td>
                                            <td>
                                                <video width="100%" height="240" controls>
                                                    <source src="{{ $vide->video_file_url }}" type="video/webm">
                                                    Your browser does not support the video tag.
                                                </video>

                                            </td>
                                        </tr>





                                        <?php
                                        //                                                                            dump( $vide->getCategory);
                                        ?>

                                    @endforeach
                                @endif


                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>

                        <div class="card-header">
                            <strong class="card-title">Role based questions</strong>

                        </div>
                        <div class="card-body">


                            <table class="table table-bordered table-hover">


                                @if(count($role_questions)>0)
                                    @foreach($role_questions as $role_question)

                                        <tr>
                                            <td>
                                                {{ $role_question->question }}
                                            </td>
                                            <td>
                                                {{ getRoleAnswers($role_question->id,$userInfo->id) }}
                                            </td>
                                        </tr>


                                    @endforeach
                                @else
                                    <tr>
                                        <td>
                                            No Data Found
                                        </td>
                                    </tr>

                                @endif


                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>


                    </div>
                </div>

            </div>

        </div><!-- .animated -->
    </div><!-- .content -->

@endsection
@section('footerScripts')

@endsection
