<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Models\Role;
use App\Models\RoleQuestions;
use Illuminate\Http\Request;

class RolesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        define('PAGE_LIMIT', 30);
    }

    public function index(Request $request)
    {
        if ($request->isMethod('post')) {
            $requestData = $request->all();

            Role::destroy($requestData['id']);

            Role::where('id', $requestData['id'])->delete();

            return redirect()->route('admin.roles')->with('flash_message', 'Role deleted successfully!');
        } else {
            $records = Role::orderBy('id', 'asc')
                ->paginate(PAGE_LIMIT);
        }
        $data = array();
        $data['active_menu'] = 'roles';
        $data['sub_active_menu'] = 'roles-list';
        $data['title'] = 'Job Roles';
        $data['records'] = $records;
        return view('backend.roles.list', $data);
    }

    public function addNewRoles(Request $request, $id = null)
    {

        if ($request->isMethod('post')) {

            $requestData = $request->all();


            $this->validate(request(), [
                'name' => 'required'
            ], [

                'name.required' => 'Enter name'
            ]);


//            dd($requestData);

            $requestData['joining_date']= isset($requestData['joining_date'])? date('Y-m-d', strtotime($requestData['joining_date'])) : null;

//            dd($requestData);

            if ($requestData['id'] == '') {



                Role::create($requestData);

                $mes = 'Role added successfully!';
            } else {

//                dd($requestData);

                $record = Role::findOrFail($requestData['id']);
                $record->update($requestData);
                $mes = 'Role updated successfully!';
            }
            return redirect()->route('admin.roles')->with('flash_message', $mes);

        } else {
            $data = array();
            $data['id'] = '';
            $data['record'] = '';
            if ($id) {
                $data['id'] = $id;
                $data['record'] = Role::findOrFail($id);
                $data['questions'] = RoleQuestions::where('role_id', $id)->get();
            }
            $data['active_menu'] = 'roles';
            $data['sub_active_menu'] = 'manage-roles';
            $data['title'] = 'Manage  Job Roles';
            $data['countryLists'] = Country::get();
            return view('backend.roles.add', $data);
        }
    }

    public function addNewQuestions(Request $request, $id = null)
    {

        if ($request->isMethod('post')) {

            $requestData = $request->all();


            if ($requestData['action'] == 'add') {

                if ($requestData['question_type'] == 'radio') {
                    $options = 'required';
                } else {
                    $options = '';
                }

                $this->validate(request(), [
                    'question' => 'required',
                    'question_type' => 'required',
                    'option1' => $options,
                    'option2' => $options,
                ], [

                    'question.required' => 'Enter question',
                    'question_type.required' => 'Select type',
                    'option1.required' => 'Enter option',
                    'option2.required' => 'Enter option',
                ]);


                RoleQuestions::create($requestData);

                $mes = 'Role questionadded successfully!';
            } elseif ($requestData['action'] == 'remove') {
                RoleQuestions::destroy($requestData['id']);
                $mes = 'Role Question deleted successfully!';
            } else {

                if ($requestData['question_type'] == 'radio') {
                    $options = 'required';
                } else {
                    $options = '';
                }

                $this->validate(request(), [
                    'question' => 'required',
                    'question_type' => 'required',
                    'option1' => $options,
                    'option2' => $options,
                ], [

                    'question.required' => 'Enter question',
                    'question_type.required' => 'Select type',
                    'option1.required' => 'Enter option',
                    'option2.required' => 'Enter option',
                ]);

                $record = RoleQuestions::findOrFail($requestData['id']);
                $record->update($requestData);
                $mes = 'Role Question updated successfully!';
            }
            return redirect()->route('admin.addNewRoles', ['id' => $requestData['role_id']])->with('flash_message', $mes);

        }
    }
}
