<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CandidateDetail extends Model
{
    use HasFactory;

    public $timestamps = false;
    protected $fillable = [
        'gapperiod',
        'current_working_email',
        'candidate_id',
        'averageStay',
        'LongestStay',
        'recommendations',
        'detail_resume',
        'template_output_data',
        'websites',
        'overalldata'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
