<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SegregatedSkill extends Model
{
    use HasFactory;

    public $timestamps = false;
    protected $fillable = [
        'type',
        'skill',
        'Ontology',
        'alias',
        'formattedname',
        'evidence',
        'lastused',
        'experienceinmonths',
        'candidate_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
