<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCandidatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidates', function (Blueprint $table) {
            $table->id();
            $table->string('full_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('mobile')->nullable();
            $table->string('country_code')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('gender')->default('Male')->comment('Male,Female,Other');
            $table->string('job_profile')->nullable();
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('zip')->nullable();
            $table->string('current_salary')->nullable();
            $table->string('expected_salary')->nullable();
            $table->string('total_experience_in_year')->nullable();
            $table->text('summary')->nullable();
            $table->string('path')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->integer('vendor_user_id')->nullable();
            $table->integer('asset_id')->nullable();
            $table->text('note')->nullable();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('marital_status')->nullable();
            $table->string('nationality')->nullable();
            $table->string('language_known')->nullable();
            $table->string('unique_id')->nullable();
            $table->string('license_no')->nullable();
            $table->string('passport_no')->nullable();
            $table->string('pan_no')->nullable();
            $table->string('visa_status')->nullable();
            $table->string('alternate_email')->nullable();
            $table->string('cover_letter')->nullable();
            $table->longText('certification')->nullable();
            $table->string('publication')->nullable();
            $table->string('current_location')->nullable();
            $table->string('preferred_location')->nullable();
            $table->string('availability')->nullable();
            $table->longText('objectives')->nullable();
            $table->string('candidate_references')->nullable();
            $table->string('parsing_date')->nullable();
            $table->string('resume_language')->nullable();
            $table->string('resume_file_name')->nullable();
            $table->string('formatted_address')->nullable();
            $table->string('permanent_address')->nullable();
            $table->string('permanent_city')->nullable();
            $table->string('permanent_state')->nullable();
            $table->string('permanent_country')->nullable();
            $table->string('permanent_zip_code')->nullable();
            $table->string('formatted_permanent_address')->nullable();
            $table->string('industry_category')->nullable();
            $table->string('industry_sub_category')->nullable();
            $table->string('qualification')->nullable();
            $table->text('executive_summary')->nullable();
            $table->text('management_summary')->nullable();
            $table->string('skills')->nullable();
            $table->string('soft_skills')->nullable();
            $table->string('operational_skills')->nullable();
            $table->longText('hobbies')->nullable();
            $table->longText('candidate_achievements')->nullable();
            $table->integer('is_privatearea')->default(1);
            $table->integer('is_alive')->default(1);
            $table->string('buyout')->default('yes')->comment('yes,no');
            $table->longText('html_code')->nullable();
            $table->string('is_active_private')->nullable();
            $table->string('preferred_country')->nullable();
            $table->string('present_country')->nullable();
            $table->string('work_autherization')->nullable();
            $table->string('currentservingnotice')->default('yes')->comment('yes,no');
            $table->string('currency')->nullable();
            $table->text('edit_summary')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('candidates');
    }
}
