<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCandidateDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidate_details', function (Blueprint $table) {
            $table->id();
            $table->integer('candidate_id')->nullable();
            $table->string('gapperiod')->nullable();
            $table->string('current_working_email')->nullable();
            $table->string('averageStay')->nullable();
            $table->string('LongestStay')->nullable();
            $table->string('recommendations')->nullable();
            $table->longText('detail_resume')->nullable();
            $table->longText('template_output_data')->nullable();
            $table->string('websites')->nullable();
            $table->longText('overalldata')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('candidate_details');
    }
}
