<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCandidatePointsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidate_points', function (Blueprint $table) {
            $table->id();
            $table->integer('job_id')->nullable();
            $table->integer('candidate_id')->nullable();
            $table->string('required_skills_points')->nullable();
            $table->string('preferred_skills_points')->nullable();
            $table->string('location_points')->nullable();
            $table->string('experience_points')->nullable();
            $table->string('position_points')->nullable();
            $table->string('qualification_points')->nullable();

            $table->string('total_points')->nullable();
            $table->string('over_all_status')->nullable();
            $table->string('jd_quality_status')->nullable();
            $table->string('jd_all_skills_count')->nullable();
            $table->string('jd_preferred_skills_count')->nullable();
            $table->string('jd_required_skills_count')->nullable();
            $table->string('cv_quality_status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('candidate_points');
    }
}
