<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSegregatedSkillsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('segregated_skills', function (Blueprint $table) {
            $table->id();
            $table->string('type')->nullable();
            $table->string('skill')->nullable();
            $table->string('Ontology')->nullable();
            $table->text('alias')->nullable();
            $table->string('formattedname')->nullable();
            $table->string('evidence')->nullable();
            $table->string('lastused')->nullable();
            $table->string('experienceinmonths')->nullable();
            $table->integer('candidate_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('segregated_skills');
    }
}
