<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('country_id');
            $table->string('currency_id');
            $table->string('salary');
            $table->string('job_type');
            $table->string('joining_date');
            $table->string('industry');
            $table->string('role_details');
            $table->text('role_details')->nullable();
            $table->text('role_expectations')->nullable();
            $table->text('after_apply')->nullable();
            $table->text('salary_incentives')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roles');
    }
}
