<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('ISD_code')->nullable();
            $table->string('country_code')->nullable();
            $table->string('currency')->nullable();
            $table->string('timezone')->nullable();
            $table->string('GMT_offset')->nullable();
            $table->string('timezone_1')->nullable();
            $table->string('fa_icon_class')->nullable();
            $table->string('is_enabled')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('countries');
    }
}
