jQuery(document).ready(function () {
    jQuery('#videos').validate({
        ignore: [],
        errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
        errorElement: 'div',
        errorPlacement: function (error, e) {
            e.parents('.form-group').append(error);
        },
        highlight: function (e) {
            $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
            $(e).closest('.text-danger').remove();
        },
        success: function (e) {
            // You can use the following if you would like to highlight with green color the input after successful validation!
            e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
            e.closest('.text-danger').remove();
        },
        rules: {
            video_name: {
                required: true
            },
            category_id: {
                required: true
            },
            video_url: {
                required: true
            },
            video_duration: {
                required: true
            },
            status: {
                required: true
            }
        },
        messages: {
            video_name: {
                required: 'Please enter name'
            },
            category_id: {
                required: 'Please select category'
            },
            video_url: {
                required: 'Please enter url'
            },
            video_duration: {
                required: 'Please enter duration'
            },
            status: {
                required: 'Please select status'
            }
        },
    });
});

