@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
<style>
    .th_p {
    color: #808080;
    font-size: 20px;
    margin-top: 10px;
}
</style>
@endsection

@section('content')
    {!! getBreadcrumbs(
               array(
               'dashboard'=>'Home',

               ''=>'Emails-Notifications'
               ),'Emails-Notifications'
            ) !!}

    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">

                        @if (Session::has('flash_message'))
                            <br/>
                            <div class="alert alert-success alert-dismissable">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <strong>{{ Session::get('flash_message' ) }}</strong>
                            </div>
                        @endif
                        @php $readonly="";
						$tooltip="";
						@endphp
						
						@if($title==1 && $desc==1 && $video==1)
							
						
                        <div class="card-body card-block">

                            <form method="POST" id="notifications" action="{{ route('admin.emails_notifications') }}"
                                  accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">Title</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <input class="form-control" id="campaign_title" type="text"
                                               placeholder="Title" data-toggle="tooltip" name="campaign_title">
                                        @if ($errors->has('campaign_title'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('campaign_title') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">Senders</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <input class="form-control" id="senders" type="text"
                                               placeholder="Senders Details separated by comma"
                                               name="senders"  data-toggle="tooltip">
                                        @if ($errors->has('senders'))
                                            <span class="text-danger help-block">{{ $errors->first('senders') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">Template</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <select class="form-control" id="template" name="template" data-toggle="tooltip">
                                            <option value="">Select Template</option>
                                            @foreach(templates() as $key=>$template)
                                                <option value="{{ $key }}">{{ $template }}</option>
                                            @endforeach

                                        </select>
                                        @if ($errors->has('senders'))
                                            <span class="text-danger help-block">{{ $errors->first('senders') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">Html Template Preview</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                      <textarea class="form-control preview" name="preview" data-toggle="tooltip">

                                      </textarea>
                                        @if ($errors->has('senders'))
                                            <span class="text-danger help-block">{{ $errors->first('senders') }}</span>
                                        @endif
                                    </div>
                                </div>


                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="fa fa-dot-circle-o"></i> Submit
                                    </button>
                                    <button type="reset" class="btn btn-danger btn-sm">
                                        <i class="fa fa-ban"></i> Reset
                                    </button>
                                </div>
                            </form>
                        </div>
                        @else
                        <div class="container">
                          <div class="col-md-8 col-md-offset-3 mai_bq text-center">
                             
                             <p class="th_p">Please update company info, videos and job title</p>
                          </div>
                       </div>
                        @endif


                    </div>
                </div>
            </div>
        </div><!-- .animated -->
    </div><!-- .content -->

@endsection
@section('footerScripts')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script src="//cdn.jsdelivr.net/bootstrap.tagsinput/0.4.2/bootstrap-tagsinput.min.js"></script>


    <script>
    
   
        $(function () {
            
            $(".tags").tagsinput()
            
            $('#template').change('click', function () {
                $('.preview').text('');
                var template = $(this).val();
                if (template != '') {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                        url: '/admin/ajax/gettemplatecontent',
                        type: 'POST',
                        data: {'template': template},
                        success: function (response) {
                            $('.preview').text(response);
                              CKEDITOR.replace( 'preview' );
    
                        }
                    });
                }
            });

            $('#notifications').validate({
                ignore: [],
                errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                errorElement: 'div',
                errorPlacement: function (error, e) {
                    e.parents('.form-group').append(error);
                },
                highlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
                    $(e).closest('.text-danger').remove();
                },
                success: function (e) {
                    // You can use the following if you would like to highlight with green color the input after successful validation!
                    e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
                    e.closest('.text-danger').remove();
                },
                rules: {
                    senders: {
                        required: true
                    },
                    campaign_title: {
                        required: true
                    },
                    template: {
                        required: true
                    },
                    preview: {
                        required: true
                    }
                },
                messages: {
                    senders: {
                        required: 'Please enter senders info'
                    },
                    campaign_title: {
                        required: 'Please enter title'
                    },
                    template: {
                        required: 'Please select template'
                    },
                    preview: {
                        required: 'Please enter title'
                    }
                },
            });
            imageRules();

        });

        function imageRules() {
            $(".logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }

        function imageRulesForVideo() {
            $(".video_logo").rules("add", {
                required: true,
                messages: {
                    required: "Upload image to save"
                }
            });
        }

    </script>

@endsection
