@extends('backend.layout')
@section('title', $title)

@section('headerStyles')
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.2-rc.1/css/select2.min.css" rel="stylesheet"/>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/0.8.2/css/flag-icon.min.css" rel="stylesheet"/>

@endsection

@section('content')
    {!! getBreadcrumbs(
               array(
               'dashboard'=>'Home',
               'admin.roles'=>'Roles',
               ''=>'Add New'
               ),'Add New Job Role'
            ) !!}

    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">

                        <div class="card-body card-block">

                            <form method="POST" id="roles" action="{{ route('admin.addNewRoles') }}"
                                  accept-charset="UTF-8" class="form-horizontal" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <input type="hidden" name="id" value="{{ $id }}">

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="name_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               class=" form-control-label">Job Title</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <input class="form-control"
                                               id="name_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="Name"
                                               name="name"
                                               value="{{ !empty(old('name')) ? old('name') : ((($record) && ($record->name)) ? $record->name : '') }}">
                                        @if ($errors->has('name'))
                                            <span class="text-danger help-block">{{ $errors->first('name') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">location</label>
                                    </div>
                                    <div class="col-12 col-md-9">
                                        <?php
                                        $curencnyLists = curencnyLists();
                                        ?>

                                        <div class="row">
                                            <div class="col-4">
                                                <select class="form-control select2" name="currency_id"
                                                        id="currency_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}">
                                                    @if(count($curencnyLists)> 0)
                                                        @foreach($curencnyLists AS $curencnyListKey=>$curencnyListValue)
                                                            <option

                                                                {{ ((($record) && ($record->currency_id ==$curencnyListKey )) ? 'selected' : '' )     }}

                                                                value="{{ $curencnyListKey }}">{{ $curencnyListValue }}</option>
                                                        @endforeach
                                                    @endif

                                                </select>
                                            </div>
                                            <div class="col-8">
                                                <select class="form-control select2_country" name="country_id"
                                                        id="location_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}">
                                                    @if(count($countryLists)> 0)
                                                        @foreach($countryLists AS $countryList)
                                                            <option
                                                                {{ ((($record) && ($record->country_id ==$countryList->country_code )) ? 'selected' : '' )     }}
                                                                value="{{ $countryList->country_code }}">
                                                                {{ $countryList->name }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>


                                        @if ($errors->has('country_id'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('country_id') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="salary_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               class=" form-control-label">salary</label>
                                    </div>
                                    <div class="col-12 col-md-9 input-group">

                                        <input class="form-control"
                                               id="salary_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="salary"
                                               name="salary"
                                               value="{{ !empty(old('salary')) ? old('salary') : ((($record) && ($record->salary)) ? $record->salary : '') }}">
                                        @if ($errors->has('salary'))
                                            <span class="text-danger help-block">{{ $errors->first('salary') }}</span>
                                        @endif
                                    </div>
                                </div>


                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="job_type_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               class=" form-control-label">job type</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <?php
                                        $role_job_types = role_job_types();
                                        ?>

                                        <select class="form-control select2" name="job_type"
                                                id="job_type_{{ ((($record) && ($record->id!='')) ? $record->id : 0 ) }}"
                                                required="required">

                                            @if(count($role_job_types)> 0)
                                                @foreach($role_job_types AS $role_job_type)
                                                    <option
                                                        {{ ((($record) && ($record->job_type ==$role_job_type )) ? 'selected' : '' )     }} value="{{ $role_job_type }}">{{ $role_job_type }}</option>
                                                @endforeach
                                            @endif
                                        </select>

                                        @if ($errors->has('job_type'))
                                            <span class="text-danger help-block">{{ $errors->first('job_type') }}</span>
                                        @endif
                                    </div>
                                </div>


                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label
                                            for="joining_date_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                            class=" form-control-label">joining date</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <input class="form-control datepicker_ui"
                                               id="joining_date_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="joining_date"
                                               name="joining_date"
                                               value="{{ isset($record->joining_date ) && $record->joining_date != '' ? date('d-m-Y', strtotime($record->joining_date)) : '' }}"

                                            {{--                                               value="{{ !empty(old('joining_date')) ? old('joining_date') : ((($record) && ($record->joining_date)) ? $record->joining_date : '') }}"--}}
                                        >
                                        @if ($errors->has('joining_date'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('joining_date') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="industry_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               class=" form-control-label">industry</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <input class="form-control "
                                               id="industry_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                               type="text"
                                               placeholder="industry"
                                               name="industry"
                                               value="{{ !empty(old('industry')) ? old('industry') : ((($record) && ($record->industry)) ? $record->industry : '') }}">
                                        @if ($errors->has('industry'))
                                            <span class="text-danger help-block">{{ $errors->first('industry') }}</span>
                                        @endif
                                    </div>
                                </div>


                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label
                                            for="role_details_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                            class=" form-control-label">Role Details</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <textarea class="form-control"
                                                  id="role_details_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                                  placeholder="Role Details"
                                                  name="role_details"
                                        >{{ !empty(old('role_details')) ? old('role_details') : ((($record) && ($record->role_details)) ? $record->role_details : '') }}</textarea>
                                        @if ($errors->has('role_details'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('role_details') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label
                                            for="role_expectations_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                            class=" form-control-label">Role Expectations</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                        <textarea class="form-control"
                                                  id="role_expectations_{{((($record) && ($record->id!='')) ? $record->id : 0 )}}"
                                                  placeholder="Role Expectations"
                                                  name="role_expectations"
                                        >{{ !empty(old('role_expectations')) ? old('role_expectations') : ((($record) && ($record->role_expectations)) ? $record->role_expectations : '') }}</textarea>
                                        @if ($errors->has('role_expectations'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('role_expectations') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">After Apply</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                                                        <textarea class="form-control" id="after_apply"
                                                                                  placeholder="After Apply"
                                                                                  name="after_apply"
                                                                        >{{ !empty(old('after_apply')) ? old('after_apply') : ((($record) && ($record->after_apply)) ? $record->after_apply : '') }}</textarea>
                                        @if ($errors->has('after_apply'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('after_apply') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="hf-email" class=" form-control-label">Salary Incentives</label>
                                    </div>
                                    <div class="col-12 col-md-9">

                                                                        <textarea class="form-control"
                                                                                  id="salary_incentives"
                                                                                  placeholder="After Apply"
                                                                                  name="salary_incentives"
                                                                        >{{ !empty(old('salary_incentives')) ? old('salary_incentives') : ((($record) && ($record->salary_incentives)) ? $record->salary_incentives : '') }}</textarea>
                                        @if ($errors->has('salary_incentives'))
                                            <span
                                                class="text-danger help-block">{{ $errors->first('salary_incentives') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="fa fa-dot-circle-o"></i> Submit
                                    </button>
                                    <button type="reset" class="btn btn-danger btn-sm">
                                        <i class="fa fa-ban"></i> Reset
                                    </button>
                                </div>
                            </form>
                        </div>

                        @if($id!='')

                            @if (Session::has('flash_message'))
                                <br/>
                                <div class="alert alert-success alert-dismissable">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                    <strong>{{ Session::get('flash_message' ) }}</strong>
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-md-8 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <p class="card-title mb-0">Roles Questions</p>

                                            <div class="table-responsive">

                                                <table class="table table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Question</th>
                                                        <th>Question type</th>
                                                        <th>Option1</th>
                                                        <th>Option2</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @if(count($questions)> 0)
                                                        @foreach($questions AS $question)
                                                            <tr>
                                                                <td>{{ $loop->iteration }}</td>
                                                                <td>{{ $question->question }}</td>
                                                                <td>{{ $question->question_type }}</td>
                                                                <td>{{ ($question->question_type=='radio') ? $question->option1 : '-' }}</td>
                                                                <td>{{ ($question->question_type=='radio') ? $question->option2 : '-' }}</td>
                                                                <td>

                                                                    <!-- Button trigger modal -->


                                                                    <form method="post"
                                                                          action="{{ route('admin.addNewQuestions') }}"
                                                                          onsubmit="return confirm('Are you sure Delete?')">
                                                                    @csrf

                                                                    <!-- Button to Open the Modal -->
                                                                        <button type="button" class="btn btn-primary"
                                                                                data-toggle="modal"
                                                                                data-target="#exampleModal{{ $loop->iteration }}">
                                                                            Edit
                                                                        </button>

                                                                        <input type="hidden" name="action"
                                                                               value="remove">
                                                                        <input type="hidden" name="id"
                                                                               value="{{ $question->id }}">
                                                                        <input type="hidden" name="role_id"
                                                                               value="{{ $id }}">

                                                                        <button type="submit"
                                                                                class="btn btn-sm btn-danger">
                                                                            X
                                                                        </button>
                                                                    </form>

                                                                    <!-- Modal -->
                                                                    <div class="modal fade"
                                                                         id="exampleModal{{ $loop->iteration }}"
                                                                         tabindex="-1" role="dialog"
                                                                         aria-labelledby="exampleModalLabel"
                                                                         aria-hidden="true">
                                                                        <div class="modal-dialog" role="document">
                                                                            <div class="modal-content">
                                                                                <div class="modal-header">
                                                                                    <h5 class="modal-title"
                                                                                        id="exampleModalLabel">Update
                                                                                        Questions</h5>
                                                                                    <button type="button" class="close"
                                                                                            data-dismiss="modal"
                                                                                            aria-label="Close">
                                                                                        <span
                                                                                            aria-hidden="true">&times;</span>
                                                                                    </button>
                                                                                </div>
                                                                                <div class="modal-body">

                                                                                    <form method="post"
                                                                                          action="{{ route('admin.addNewQuestions') }}"
                                                                                          id="questionsForm"
                                                                                          class="questionsForm">
                                                                                        @csrf

                                                                                        <input type="hidden"
                                                                                               name="action"
                                                                                               value="edit">
                                                                                        <input type="hidden" name="id"
                                                                                               value="{{ $question->id }}">

                                                                                        @include('backend.roles.questions-form')

                                                                                        <div class="form-group">
                                                                                            <button type="submit"
                                                                                                    class="btn btn-outline-primary">
                                                                                                Update
                                                                                            </button>
                                                                                        </div>

                                                                                    </form>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="button"
                                                                                            class="btn btn-secondary"
                                                                                            data-dismiss="modal">Close
                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>


                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="4">No Data Found</td>
                                                        </tr>

                                                    @endif


                                                    </tbody>
                                                </table>
                                                <?php
                                                $question = '';
                                                ?>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <h4 class="card-title">Create Questions</h4>


                                            <form method="post" action="{{ route('admin.addNewQuestions') }}"
                                                  id="questionsForm" class="questionsForm">
                                                @csrf

                                                <input type="hidden" name="action" value="add">

                                                @include('backend.roles.questions-form')

                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-outline-primary">Save</button>
                                                </div>


                                            </form>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        @endif

                    </div>
                </div>
            </div>
        </div><!-- .animated -->
    </div><!-- .content -->

@endsection
@section('footerScripts')

    {{--    <script src="{{url('backend/modules/roles/js/roles.js')}}"></script>--}}
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.2-rc.1/js/select2.min.js"
            type="text/javascript"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/0.8.2/css/flag-icon.min.css" rel="stylesheet"/>

    <script>
        $(function () {
            $(".datepicker_ui").datepicker({
                dateFormat: 'dd-mm-yy',
                changeMonth: true,
                changeYear: true,
            });

            $('.select2').select2();

            $('.select2_country').select2({
                placeholder: '-Select Country-',
                templateResult: formatCountry,
                templateSelection: formatCountry
            });

            function formatCountry(country) {
                if (!country.id) {
                    return country.text;
                }


                console.log(country)

                // 'code'

                var $country = $(
                    '<span class="flag-icon flag-icon-' + country.id.toLowerCase() + ' flag-icon-squared"></span>' + '<span style="margin-left:10px;">' + country.text + '</span>'
                );
                return $country;
            };

        });
    </script>

    <script>
        $(function () {

            $(document.body).on('change', "#question_type_options", function (e) {

                if ($(this).val() == 'radio') {
                    $('.optionsdiv').show();
                } else {
                    $('.optionsdiv').hide();
                }
            });

            $('#roles').validate({
                ignore: [],
                errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                errorElement: 'div',
                errorPlacement: function (error, e) {
                    e.parents('.form-group').append(error);
                },
                highlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-success has-error').addClass('has-error');
                    $(e).closest('.text-danger').remove();
                },
                success: function (e) {
                    // You can use the following if you would like to highlight with green color the input after successful validation!
                    e.closest('.form-group').removeClass('has-success has-error'); // e.closest('.form-group').removeClass('has-success has-error').addClass('has-success');
                    e.closest('.text-danger').remove();
                },
                rules: {
                    name: {
                        required: true
                    },
                    country_id: {
                        required: true
                    },
                    currency_id: {
                        required: true
                    },
                    salary: {
                        required: true
                    },
                    job_type: {
                        required: true
                    },
                    joining_date: {
                        required: true
                    },
                    industry: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: 'Please enter name'
                    },
                    country_id: {
                        required: "Select Country"
                    },
                    currency_id: {
                        required: "Select Currency"
                    },
                    salary: {
                        required: "Enter salary"
                    },
                    job_type: {
                        required: "Select Job Type"
                    },
                    joining_date: {
                        required: "Select Joining date"
                    },
                    industry: {
                        required: "Enter Industry"
                    },
                },
            });


            $('.questionsForm').each(function () {
                $($(this)).validate({
                    ignore: [],
                    errorClass: 'text-danger', // You can change the animation class for a different entrance animation - check animations page
                    errorElement: 'div',
                    highlight: function (element) {
                        jQuery(element).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (element) {
                        jQuery(element).closest('.form-group').removeClass('has-error');
                    },
                    errorPlacement: function (error, element) {
                        if (element.parent('.input-group').length) {
                            error.insertAfter(element.parent());
                        } else {
                            error.insertAfter(element);
                        }
                    },
                    rules: {
                        question: {
                            required: true
                        },
                        // option1: {
                        //     required: true
                        // },
                        // option2: {
                        //     required: true
                        // },
                        question_type: {
                            required: true
                        }


                    },
                    messages: {

                        question: {
                            required: 'Please enter question'
                        },
                        // option1: {
                        //     required: 'Please enter option'
                        // },
                        // option2: {
                        //     required: 'Please enter option'
                        // },
                        question_type: {
                            required: 'Select question type'
                        }


                    },
                    submitHandler: function (form) {

                        return true;
                    }
                });

            })

        });


    </script>

@endsection
