<input type="hidden" name="role_id" value="{{ $id }}"/>

<div class="form-group ">
    <label for="name_{{  !empty($question) ? $question->id : '' }}" class=" text-md-right">{{ __('Question') }}</label>

    <div class="input-group">
        <input id="name_{{!empty($question) ? $question->id : ''}}" type="text"
               class="form-control @error('question') is-invalid @enderror" name="question"
               value="{{ !empty($question) ?  $question->question : '' }}" required autocomplete="name" autofocus>

        @error('question')
        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
        @enderror
    </div>
</div>

<div class="form-group ">
    <label for="question_type"
           class=" text-md-right">{{ __('Question type') }}</label>

    <div class="input-group">
        <select id="question_type_options"
                class="form-control @error('question_type') is-invalid @enderror" name="question_type">
            <option value="">Select type</option>

            @foreach(questionTypes('types') AS $typekey=>$typevalue)
                @if(!empty($question))
                    <option
                        {{ !empty($question) &&  $question->question_type == $typekey ? 'selected' : 'disabled' }} value="{{$typekey}}">{{ $typevalue }}</option>

                @else
                    <option
                         value="{{$typekey}}">{{ $typevalue }}</option>

                @endif
            @endforeach


        </select>
        @error('question_type')
        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
        @enderror
    </div>
</div>
@if(!empty($question) && $question->question_type=='radio')
    <div class="optionsdiv">
        @else
            <div class="optionsdiv" style="display: none">
                @endif
                <div class="form-group ">
                    <label for="option1_{{  !empty($question) ? $question->id : '' }}"
                           class=" text-md-right">{{ __('Option1') }}</label>

                    <div class="input-group">
                        <input id="option1_{{!empty($question) ? $question->id : ''}}" type="text"
                               class="form-control @error('option1') is-invalid @enderror" name="option1"
                               value="{{ !empty($question) ?  $question->option1 : '' }}" autocomplete="option1">

                        @error('option1')
                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                        @enderror
                    </div>
                </div>
                <div class="form-group ">
                    <label for="option2_{{  !empty($question) ? $question->id : '' }}"
                           class=" text-md-right">{{ __('Option2') }}</label>

                    <div class="input-group">
                        <input id="option2_{{!empty($question) ? $question->id : ''}}" type="text"
                               class="form-control @error('option2') is-invalid @enderror" name="option2"
                               value="{{ !empty($question) ?  $question->option2 : '' }}" autocomplete="option2">

                        @error('option2')
                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                        @enderror
                    </div>
                </div>

            </div>
