<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', function () {
//    return view('welcome');
//});
//
//Auth::routes();
//
//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

use \App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\backend\AdminController;
use App\Http\Controllers\backend\VideoInterviewCategoriesController;
use App\Http\Controllers\backend\VideoInterviewCategoriesVideosController;
use App\Http\Controllers\backend\RolesController;


Route::prefix('admin')->group(function () {

    Route::get('/', [LoginController::class,'showLoginForm'])->name('login');
    Route::post('/', [LoginController::class,'login']);
    Route::post('/logout', [LoginController::class,'logout'])->name('logout');


    Route::get('/dashboard', [AdminController::class,'index'])->name('dashboard');

    Route::get('/users', [AdminController::class,'users'])->name('admin.users');

    Route::get('/completed-users/{id?}', [AdminController::class,'completedUsers'])->name('admin.completedusers');

    Route::get('/incompleted-users/{id?}', [AdminController::class,'inCompleteUsers'])->name('admin.incompleteusers');

    /* Video Categories module routes */
    Route::match(array('GET', 'POST'), '/video-categories', [VideoInterviewCategoriesController::class,'index'])->name('admin.videos.categories');
    Route::match(array('GET', 'POST'), '/video-categories/manage/{id?}', [VideoInterviewCategoriesController::class,'addNewCategories'])->name('admin.videos.addNewCategories');

    /* Interview Videos module routes */
    Route::match(array('GET', 'POST'), '/interview-videos', [VideoInterviewCategoriesVideosController::class,'index'])->name('admin.videos.videos');
    Route::match(array('GET', 'POST'), '/interview-videos/manage/{id?}', [VideoInterviewCategoriesVideosController::class,'addNewCategoriesVideos'])->name('admin.videos.addNewCategoriesVideos');
	
	Route::match(array('GET', 'POST'), '/interview-videos/manage/manauallyupload', [VideoInterviewCategoriesVideosController::class,'manauallyUploadVideos'])->name('admin.videos.manauallyUploadVideos');

    /* Roles module routes */
    Route::match(array('GET', 'POST'), '/roles', [RolesController::class,'index'])->name('admin.roles');
    Route::match(array('GET', 'POST'), '/roles/manage/{id?}', [RolesController::class,'addNewRoles'])->name('admin.addNewRoles');

    Route::match(array('GET', 'POST'), '/roles-questions', [RolesController::class,'addNewQuestions'])->name('admin.addNewQuestions');
    Route::match(array('GET', 'POST'), '/settings', [AdminController::class,'settings'])->name('admin.settings');
    Route::match(array('GET', 'POST'), '/emails-notifications', [AdminController::class,'emailsNotifications'])->name('admin.emails_notifications');
    Route::post('ajax/gettemplatecontent', [AdminController::class,'gettemplatecontent'])->name('gettemplatecontent');

    Route::post('ajax/deletelogo', [AdminController::class,'deletelogo'])->name('deletelogo');
    Route::post('ajax/deletevideologo', [AdminController::class,'deletevideologo'])->name('deletevideologo');
	Route::match(array('GET', 'POST'), '/introduction-content', [AdminController::class,'introduction_content'])->name('admin.introduction-content');

});



Route::get('/{steps?}/{role?}', [UserController::class,'index'])->name('home');
Route::get('signup', [UserController::class,'signup']);
Route::post('user_register', [UserController::class,'user_register']);
Route::get('user_info/{emails}/{userid}', [UserController::class,'interview_questions']);
Route::post('user_information', [UserController::class,'user_information']);
Route::get('interview_questions/{email}/{userid}', [UserController::class,'interview_all_questions']);
Route::get('interview_questions/{email}/{userid}/{id}', [UserController::class,'interview_all_questions'])->name('interview_questions');
Route::get('role_questions/{email}/{userid}/{id}', [UserController::class,'role_questions'])->name('role_questions');
Route::post('save_question', [UserController::class,'save_question']);
Route::post('save_role_question', [UserController::class,'save_role_question']);
Route::post('upload_resume', [UserController::class,'upload_resume']);
Route::post('send_otp', [UserController::class,'send_otp']);
Route::post('save_mobile_number', [UserController::class,'save_mobile_number']);
Route::get('thanks_you/{email}/{userid}', [UserController::class,'thanks_you'])->name('thankyou');
Route::get('not_suitable/{email}/{userid}', [UserController::class,'not_suitable']);
Route::get('categories/{email}/{userid}/{categoryid}', [UserController::class,'categories'])->name('videoInterviewCategories');

Route::match(['get','post'],'save/video', [UserController::class,'saveVideo'])->name('saveVideo');
Route::match(['get','post'],'save/categoryVideo', [UserController::class,'saveCategoryVideo'])->name('saveCategoryVideo');

Route::match(['get','post'],'verify/email/tostart', [UserController::class,'verifyEmail'])->name('startnow');


Route::prefix('ajax')->group(function () {
    Route::match(['get', 'post'], 'saveCategoryVideoSort', [UserController::class, 'saveCategoryVideoSort'])->name('saveCategoryVideoSort');
});
//
//Route::get('/dashboard', function () {
//    return view('dashboard');
//})->middleware(['auth'])->name('dashboard');
////
//require __DIR__.'/auth.php';
