<!doctype html>
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Anantha Interviews Admin - LOGIN</title>
    <meta name="description" content="Sufee Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="/backend/apple-icon.png">
    <link rel="shortcut icon" href="/backend/favicon.ico">

    <link rel="stylesheet" href="/backend/assets/css/all.css">

    <link rel="stylesheet" href="/backend/assets/css/theme.css">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>
</head>
<body class="bg-dark">
<div class="sufee-login d-flex align-content-center flex-wrap">
    <div class="container">
        <div class="login-content">
            <div class="login-form">
                <form method="POST" action="<?php echo e(route('login')); ?>" aria-label="<?php echo e(__('Login')); ?>">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <label>Email address</label>
                        <input id="email" type="email"
                               class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email"
                               value="<?php echo e(old('email')); ?>" placeholder="Email">
                        <?php if($errors->has('email')): ?>
                            <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                    </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input id="password" type="password"
                               class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password"
                               placeholder="Password">
                        <?php if($errors->has('password')): ?>
                            <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                        <?php endif; ?>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox"
                                   name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>> <?php echo e(__('Remember Me')); ?>


                        </label>
                    <!--    <label class="pull-right">

                    
                            </a>
                                </label>-->
                    </div>
                    <button type="submit" class="btn btn-dark btn-flat m-b-30 m-t-30">Sign in</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="/backend/assets/js/main.js"></script>
</body>
</html>
<?php /**PATH /home/indiabestjobs/public_html/subdomain/interviewtool/resources/views/auth/login.blade.php ENDPATH**/ ?>