<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('headerStyles'); ?>

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            display: none;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #3c8dbc;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              'admin.incompleteusers'=>'Incompleted Users',
              ''=>'Incompleted User Info'
              ),'Incompleted User Info'
           ); ?>


    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">

                <div class="col-lg-12">
                    <?php if(Session::has('flash_message')): ?>
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong><?php echo e(Session::get('flash_message' )); ?></strong>
                        </div>
                    <?php endif; ?>
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Incompleted User Info</strong>

                        </div>
                        <div class="card-body">


                            <table class="table table-bordered table-hover">

                                <tr>
                                    <td>
                                        Name
                                    </td>
                                    <td>
                                        <?php echo e(isset($userInfo) ? $userInfo->name : ''); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Email
                                    </td>
                                    <td>
                                        <?php echo e(isset($userInfo) ? $userInfo->email : ''); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Mobile
                                    </td>
                                    <td>
                                        +<?php echo e(isset($userInfo) ? $userInfo->country_code."-".$userInfo->mobile : ''); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Role
                                    </td>
                                    <td>
                                        <?php echo e(isset($userInfo) ? $userInfo->getRole->name : ''); ?>

                                    </td>
                                </tr>

                                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td>
                                            <?php echo e($question->question); ?>

                                        </td>
                                        <td>
                                            <?php echo e(isset($userInfo) ? getUserAnswers($question->id,$userInfo->id,$question->flag) : ''); ?>

                                        </td>
                                    </tr>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                <?php if(isset($userInfo) && count($userInfo->getRecords)> 0): ?>
                                    <?php $__currentLoopData = $userInfo->getRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                        //                                        dump($vide->getRefVideo);
                                        ?>

                                        <tr>
                                            <td>
                                                <h2>
                                                    <?php echo e(isset($vide->getCategory)? $vide->getCategory->name : ''); ?>

                                                </h2>
                                                <h6>
                                                    <?php echo e(isset($vide->getRefVideo->video_name) ? $vide->getRefVideo->video_name : ''); ?>

                                                </h6>

                                                <video class="i_fram" width="100%" height="240" controls>
                                                    <source src="<?php echo e($vide->getRefVideo->video_url_file); ?>"
                                                            type="video/webm">
                                                    Your browser does not support the video tag.
                                                </video>
                                                
                                                
                                                
                                                
                                                
                                            </td>
                                            <td>
                                                <video width="100%" height="240" controls>
                                                    <source src="<?php echo e($vide->video_file_url); ?>" type="video/webm">
                                                    Your browser does not support the video tag.
                                                </video>

                                            </td>
                                        </tr>





                                        <?php
                                        //                                                                            dump( $vide->getCategory);
                                        ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>


                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>

                        <div class="card-header">
                            <strong class="card-title">Role based questions</strong>

                        </div>
                        <div class="card-body">


                            <table class="table table-bordered table-hover">


                                <?php if(count($role_questions)>0): ?>
                                    <?php $__currentLoopData = $role_questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role_question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            <td>
                                                <?php echo e($role_question->question); ?>

                                            </td>
                                            <td>
                                                <?php echo e(getRoleAnswers($role_question->id,$userInfo->id)); ?>

                                            </td>
                                        </tr>


                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td>
                                            No Data Found
                                        </td>
                                    </tr>

                                <?php endif; ?>


                            </table>


                            <?php
                            //                            dump($userInfo->getRecords);
                            ?>


                        </div>


                    </div>
                </div>

            </div>

        </div><!-- .animated -->
    </div><!-- .content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerScripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/indiabestjobs/public_html/subdomain/interviewtool/resources/views/backend/users/incompleted_userInfo.blade.php ENDPATH**/ ?>