
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('headerStyles'); ?>

    <style>

        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            display: none;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #3c8dbc;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              ''=>'Completed Users'
              ),'Completed Users'
           ); ?>


    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">

                <div class="col-lg-12">
                    <?php if(Session::has('flash_message')): ?>
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong><?php echo e(Session::get('flash_message' )); ?></strong>
                        </div>
                    <?php endif; ?>
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Completed Users</strong>

                        </div>
                        <div class="card-body">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Mobile</th>
                                    <th scope="col">Role</th>
                                    <th scope="col">Actions</th>

                                </tr>
                                </thead>
                                <tbody>
                                <?php if(count($records)>0): ?>
                                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->email); ?></td>
                                            <td><?php echo e($item->country_code."-".$item->mobile); ?></td>
                                            <td><?php echo e((isset($item->getRole)) ? $item->getRole->name : ''); ?></td>

                                            <td>


                                                <a class="btn btn-primary" href="<?php echo e(route('admin.completedusers',['id'=>$item->id])); ?>">
                                                    View Application Info
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7">No records found</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md-10">
                    <div class="dataTables_info p-t-10" id="editable-datatable_info" role="status"
                         aria-live="polite">Showing <?php echo e($records->firstItem()); ?>

                        to <?php echo e($records->lastItem()); ?> of <?php echo e($records->total()); ?> entries
                    </div>
                </div>
                <div class="col-md-1 text-right">
                    <div class="dataTables_paginate paging_simple_numbers" id="editable-datatable_paginate">
                        <?php echo $records->appends(['filters' => Request::get('filters'),'search' => Request::get('search')])->render(); ?>

                    </div>
                </div>
            </div>
        </div><!-- .animated -->
    </div><!-- .content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerScripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/indiabestjobs/public_html/subdomain/interviewtool/resources/views/backend/users/completed_users.blade.php ENDPATH**/ ?>