
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('headerStyles'); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo getBreadcrumbs(
              array(
              'dashboard'=>'Home',
              ''=>'Job Roles'
              ),'Roles'
           ); ?>


    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">

                <div class="col-lg-12">
                    <?php if(Session::has('flash_message')): ?>
                        <br/>
                        <div class="alert alert-success alert-dismissable">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong><?php echo e(Session::get('flash_message' )); ?></strong>
                        </div>
                    <?php endif; ?>
                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">Roles</strong>
                            <a href="<?php echo e(route('admin.addNewRoles')); ?>" class="btn btn-primary btn-xs" style="float:right;">Add
                                Roles
                            </a>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Industry</th>
                                    <th scope="col">Job Type</th>
                                    <th scope="col">Joining Date</th>
                                    <th scope="col">Role Details</th>
                                    <th scope="col">Role Expectations</th>
                                    <th scope="col">After Apply</th>
                                    <th scope="col">Salary Incentives</th>
                                    <th scope="col">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(count($records)>0): ?>
                                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->industry); ?></td>
                                            <td><?php echo e($item->job_type); ?></td>
                                            <td><?php echo e($item->joining_date!= '' ? date('d-m-Y', strtotime($item->joining_date)) :''); ?></td>
                                            <td><?php echo $item->role_details; ?></td>
                                            <td><?php echo $item->role_expectations; ?></td>
                                            <td><?php echo $item->after_apply; ?></td>
                                            <td><?php echo $item->salary_incentives; ?></td>
                                            <td>
                                                <div class="dropdown">
                                                    <a class="btn btn-outline-primary dropdown-toggle" href="#"
                                                       role="button"
                                                       data-toggle="dropdown">
                                                        <i class="fa fa-ellipsis-h"></i>
                                                    </a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <a class="dropdown-item"
                                                           href="<?php echo e(route('admin.addNewRoles',['id'=>$item->id])); ?>"><i
                                                                class="fa fa-pencil"></i> Edit</a>
                                                        <form method="POST" id="roles"
                                                              action="<?php echo e(route('admin.roles')); ?>"
                                                              accept-charset="UTF-8" class="form-horizontal"
                                                              style="display:inline">
                                                            <?php echo e(csrf_field()); ?>

                                                            <input type="hidden" name="id"
                                                                   value="<?php echo e($item->id); ?>"/>
                                                            <button type="submit" class="dropdown-item"
                                                                    title="Delete Record"
                                                                    onclick="return confirm(&quot;Confirm delete?&quot;)">
                                                                <i
                                                                    class="fa fa-trash"></i> Delete
                                                            </button>

                                                        </form>

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7">No records found</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md-10">
                    <div class="dataTables_info p-t-10" id="editable-datatable_info" role="status"
                         aria-live="polite">Showing <?php echo e($records->firstItem()); ?>

                        to <?php echo e($records->lastItem()); ?> of <?php echo e($records->total()); ?> entries
                    </div>
                </div>
                <div class="col-md-1 text-right">
                    <div class="dataTables_paginate paging_simple_numbers" id="editable-datatable_paginate">
                        <?php echo $records->appends(['filters' => Request::get('filters'),'search' => Request::get('search')])->render(); ?>

                    </div>
                </div>
            </div>
        </div><!-- .animated -->
    </div><!-- .content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerScripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/indiabestjobs/public_html/subdomain/interviewtool/resources/views/backend/roles/list.blade.php ENDPATH**/ ?>