const mix = require('laravel-mix');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel applications. By default, we are compiling the CSS
 | file for the application as well as bundling up all the JS files.
 |
 */

mix.js('resources/js/app.js', 'public/js').postCss('resources/css/app.css', 'public/css', [
    require('postcss-import'),
    require('tailwindcss'),
    require('autoprefixer'),
]);

// images
mix.copyDirectory('resources/assets/backend/images', 'public/backend/images');

// Modules
mix.js('resources/assets/backend/js/main.js', 'public/backend/assets/js')
    .js('resources/assets/backend/modules/categories/js/categories.js', 'public/backend/modules/categories/js/')
    .js('resources/assets/backend/modules/roles/js/roles.js', 'public/backend/modules/roles/js/')
    .js('resources/assets/backend/modules/videos/js/videos.js', 'public/backend/modules/videos/js/')
    .js('resources/assets/backend/js/dashboard.js', 'public/backend/assets/js');

// styles
mix.sass('resources/assets/backend/scss/theme.scss', 'public/backend/assets/css');

mix.styles([
    'resources/assets/backend/css/normalize.css',
    'resources/assets/backend/css/cs-skin-elastic.css',
    'resources/assets/backend/css/themify-icons.css',
    'resources/assets/backend/assets/css/flag-icon.min.css'
], 'public/backend/assets/css/all.css');
